function [y,xI,xE] = simulateTwoStateCompetition(pars,r,context)
% stores input variables using descriptive names
aI = pars(1); % retention for acceleration
aE = pars(2); % retention for deceleration
bI = pars(3); % error sensitivity for acceleration
bE = pars(4); % error sensitivity for deceleration

% get the number of trials
N = length(r);

% allocate space
xI = zeros(N,1);
xE = zeros(N,1);
y = zeros(N,1); 
e = zeros(N,1);

% the initial behavior
y(1) = xI(1) + xE(1);

% the first error
e(1) = r(1) - y(1);

% iterate through all trials
for n = 2 : N
    % learning
    if context(n-1) == 1
       % the adapted target was visited
        xI(n) = aI*xI(n-1) + bI*e(n-1);
        xE(n) = aE*xE(n-1) + bE*e(n-1);
    else
        % the non-adapted target was visited
        xI(n) = aI*xI(n-1);
        xE(n) = aE*xE(n-1);
    end
    
    % calculate the behavior
    y(n) = xI(n) + xE(n);
    
    % calculate the error
    e(n) = r(n) - y(n);
end

end