function [] = figure5_supplement1()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Experiment 1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
dd = load('data-experiment-1.mat');
iS = dd.iS; eS = dd.eS; tS = dd.tS;
iA = dd.iA; eA = dd.eA; tA = dd.tA;

% concatenate stepwise and abrupt
x = [tS(4,:)';tA(4,:)'];
y = [iS(4,:)';iA(4,:)'];

% plot the result
figure
subplot(3,3,2)
hold on
plot(x,y,'.k')
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')
p = polyfit(x,y,1);
ypred = polyval(p,x);
plot(x,ypred,'-','Color',[70,54,33]/255,'LineWidth',1);
title('Figure 5-S1B')


x = [tS(4,:)';tA(4,:)'];
y = [eS(4,:)';eA(4,:)'];
subplot(3,3,5)
hold on
plot(x,y,'.k')
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-k')
ax = gca;
ax.TickDir = 'out';
ylabel('explicit angle (deg)')
xlabel('total adaptation (deg)')
p = polyfit(x,y,1);
ypred = polyval(p,x);
plot(x,ypred,'-','Color',[70,54,33]/255,'LineWidth',1);
title('Figure 5-S1E')

x = [eS(4,:)';eA(4,:)'];
y = [iS(4,:)';iA(4,:)'];
subplot(3,3,8)
hold on
plot(x,y,'.k')
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
p = polyfit(x,y,1);
ypred = polyval(p,x);
plot(x,ypred,'-','Color',[70,54,33]/255,'LineWidth',1);
title('Figure 5-S1H')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% Maresch et al. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load data
dd = load('data-maresch');
I_inter_exclude = dd.I_inter_exclude;
I_EI_exclude = dd.I_EI_exclude;
I_cts_exclude = dd.I_cts_exclude;
T_inter = dd.T_inter;
T_EI = dd.T_EI;
T_cts = dd.T_cts;
E_inter_exclude = dd.E_inter_exclude;
E_EI_exclude = dd.E_EI_exclude;
E_cts_exclude = dd.E_cts_exclude;

% figures
subplot(3,3,1)
hold on
plot(T_inter,I_inter_exclude,'.k')
plot(T_cts,I_cts_exclude,'.k')
plot(T_EI,I_EI_exclude,'.k')
ylabel('implicit exclude')
xlabel('total exclude')
x = [T_inter;T_EI;T_cts];
y = [I_inter_exclude;I_EI_exclude;I_cts_exclude];
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
xlabel('total adaptation (deg)')
ylabel('implicit angle (deg)')
title('Figure 5-S1A')

subplot(3,3,4)
hold on
plot(T_inter,E_inter_exclude,'.k')
plot(T_cts,E_cts_exclude,'.k')
plot(T_EI,E_EI_exclude,'.k')
ylabel('explicit exclude')
xlabel('total exclude')
x = [T_inter;T_EI;T_cts];
y = [E_inter_exclude;E_EI_exclude;E_cts_exclude];
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
xlabel('total adaptation (deg)')
ylabel('explicit angle (deg)')
title('Figure 5-S1D')

subplot(3,3,7)
hold on
x = [E_inter_exclude;E_EI_exclude;E_cts_exclude];
y = [I_inter_exclude;I_EI_exclude;I_cts_exclude];
plot(x,y,'.k')
pp = polyfit(x,y,1);
yfit = polyval(pp,x);
plot(x,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
xlabel('explicit angle (deg)')
ylabel('implicit angle (deg)')
title('Figure 5-S1G')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Tsay analysis %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data
dd = load('data-tsay.mat');
i60 = dd.i60;
e60 = dd.e60;
t60 = dd.t60;

subplot(3,3,3)
hold on
plot(t60,i60,'.k')
pp = polyfit(t60,i60,1);
yfit = polyval(pp,t60);
plot(t60,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
ax = gca;
ax.TickDir = 'out';
xlabel('total adaptation (deg)')
ylabel('implicit angle (deg)')
title('Figure 5-S1C')

subplot(3,3,6)
hold on
plot(t60,e60,'.k')
pp = polyfit(t60,e60,1);
yfit = polyval(pp,t60);
plot(t60,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
ax = gca;
ax.TickDir = 'out';
xlabel('total adaptation (deg)')
ylabel('explicit angle (deg)')
title('Figure 5-S1F')

subplot(3,3,9)
hold on
plot(e60,i60,'.k')
pp = polyfit(e60,i60,1);
yfit = polyval(pp,e60);
plot(e60,yfit,'-','Color',[70,54,33]/255,'LineWidth',1);
ax = gca;
ax.TickDir = 'out';
xlabel('explicit angle (deg)')
ylabel('implicit angle (deg)')
title('Figure 5-S1I')

end