function [] = figure1_supplement3()

% the trial numbers to calculate behavior
tnumbers = [5,10,20,40,150];

% set the random number seed
rng(1)

% parameters for simulations
ai=0.9829^3;ae=0.9278^3;bi=0.0629;be=0.15;
simnumber=10000;

% simulate the approximate result
[i,e,ia] = simulateapprox(ai,bi,ae,be,30,200);
figure
subplot(3,5,2:4)
hold on
plot(i,'-c')
plot(ia,'--r')
plot(e,'-m')
for f = 1 : length(tnumbers)
    plot([tnumbers(f),tnumbers(f)],[0,15],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('reach angle (deg)')
xlabel('cycle number')
title('Figure 2-Supplement 3A')

% the implicit and explicit simulation results
idx = 5;
for tnumber = tnumbers
    idx = idx + 1;
    subplot(3,5,idx)
    hold on
    
    [i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [i2,i2s] = simulatesystem(ai,bi,ae,2.9*be,45,tnumber,simnumber);
    bar(4,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([4,4],[i1-i1s,i1+i1s],'-k')
    bar(5,i2,'FaceColor','b','EdgeColor','k')
    plot([5,5],[i2-i2s,i2+i2s],'-k')
    
    [i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [i2,i2s] = simulatesystem(ai,bi,ae,be,45,tnumber,simnumber);
    bar(1,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([1,1],[i1-i1s,i1+i1s],'-k')
    bar(2,i2,'FaceColor','g','EdgeColor','k')
    plot([2,2],[i2-i2s,i2+i2s],'-k')
    
    [i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [i2,i2s] = simulatesystem(ai,bi,ae,6.2*be,45,tnumber,simnumber);
    bar(7,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([7,7],[i1-i1s,i1+i1s],'-k')
    bar(8,i2,'FaceColor','m','EdgeColor','k')
    plot([8,8],[i2-i2s,i2+i2s],'-k')
    ylim([0,25])
    ax = gca;
    ax.TickDir = 'out';
end

idx = 10;
for tnumber = tnumbers
    idx = idx + 1;
    subplot(3,5,idx)
    hold on
    
    [~,~,i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [~,~,i2,i2s] = simulatesystem(ai,bi,ae,2.9*be,45,tnumber,simnumber);
    bar(4,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([4,4],[i1-i1s,i1+i1s],'-k')
    bar(5,i2,'FaceColor','b','EdgeColor','k')
    plot([5,5],[i2-i2s,i2+i2s],'-k')
    
    [~,~,i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [~,~,i2,i2s] = simulatesystem(ai,bi,ae,be,45,tnumber,simnumber);
    bar(1,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([1,1],[i1-i1s,i1+i1s],'-k')
    bar(2,i2,'FaceColor','g','EdgeColor','k')
    plot([2,2],[i2-i2s,i2+i2s],'-k')
    
    [~,~,i1,i1s] = simulatesystem(ai,bi,ae,be,30,tnumber,simnumber);
    [~,~,i2,i2s] = simulatesystem(ai,bi,ae,6.2*be,45,tnumber,simnumber);
    bar(7,i1,'FaceColor',[200,200,200]/255,'EdgeColor','k')
    plot([7,7],[i1-i1s,i1+i1s],'-k')
    bar(8,i2,'FaceColor','m','EdgeColor','k')
    plot([8,8],[i2-i2s,i2+i2s],'-k')
    ylim([0,45])
    ax = gca;
    ax.TickDir = 'out';
end
subplot(3,5,6)
ylabel('implicit angle (deg)')
title('Figure 2-Supplement 3B')
subplot(3,5,11)
ylabel('explicit angle (deg)')
title('Figure 2-Supplement 3C')