function [] = figure9()

% load the data
load('data-experiment-5.mat','A5A','A5B','A24A','A24B','RT5A','RT5B','RT24A','RT24B',...
    'E5','E24','lerner5','lerner24');

% computes the number of subjects in each group
N5 = size(A5A,2);
N24 = size(A24A,2);

% plot the RT in epochs
figure
subplot(2,3,1)
hold on
m5B = nanmean(RT5B,2);
s5B = nanstd(RT5B,[],2) / sqrt(N5);
plot(m5B,'-b')
plot(m5B-s5B,'--b')
plot(m5B+s5B,'--b')
ylabel('prep. time (s)')
xlim([1,100])
ylim([0.15,0.5])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0.2 : 0.1 : 0.5;
ax.XTick = [1,20:20:80];
title('Figure 9A')

% the Lerner et al. results
m = 0.3955;
s = 0.0131;
plot([1,80],[m,m],'-g')
plot([1,80],[m+s,m+s],'--g')
plot([1,80],[m-s,m-s],'--g')

subplot(2,3,2)
hold on
m24B = nanmean(RT24B,2);
s24B = nanstd(RT24B,[],2) / sqrt(N24);
plot(m24B,'-b')
plot(m24B-s24B,'--b')
plot(m24B+s24B,'--b')
xlim([1,100])
ylim([0.15,0.5])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0.2 : 0.1 : 0.5;
ax.XTick = [1,20:20:80];
title('Figure 9B')

% the Lerner et al. results
m = 0.4349;
s = 0.0147;
plot([1,80],[m,m],'-g')
plot([1,80],[m+s,m+s],'--g')
plot([1,80],[m-s,m-s],'--g')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%% compare B with -A %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m5A = nanmean(-A5A,2);
s5A = nanstd(-A5A,[],2) / sqrt(N5);
m5B = nanmean(A5B,2);
s5B = nanstd(A5B,[],2) / sqrt(N5);
m24A = nanmean(-A24A,2);
s24A = nanstd(-A24A,[],2) / sqrt(N24);
m24B = nanmean(A24B,2);
s24B = nanstd(A24B,[],2) / sqrt(N24);

% shorten the A period
m5A = m5A(5:end); s5A = s5A(5:end);
m24A = m24A(5:end); s24A = s24A(5:end);

expfun = @(x,y0,idx) -x(1) + (y0 + x(1)) * exp(-x(2)*idx);

y = m5A;
idx = find(~isnan(y));
y = y(idx);
p5A = fmincon(@(x) sum((y-expfun(x,y(1),idx-1)).^2),[25,0.1],[],[]);
y = m5B;
idx = find(~isnan(y));
y = y(idx);
p5B = fmincon(@(x) sum((y-expfun(x,y(1),idx-1)).^2),[25,0.1],[],[]);
y = m24A;
idx = find(~isnan(y));
y = y(idx);
p24A = fmincon(@(x) sum((y-expfun(x,y(1),idx-1)).^2),[25,0.1],[],[]);
y = m24B;
idx = find(~isnan(y));
y = y(idx);
p24B = fmincon(@(x) sum((y-expfun(x,y(1),idx-1)).^2),[25,0.1],[],[]);

% the x-intercept
a = p5A(1); b = p5A(2);
t5A = -(1/b)*log(a / (m5A(1) + a));
a = p5B(1); b = p5B(2);
t5B = -(1/b)*log(a / (m5B(1) + a));
a = p24A(1); b = p24A(2);
t24A = -(1/b)*log(a / (m24A(1) + a));
a = p24B(1); b = p24B(2);
t24B = -(1/b)*log(a / (m24B(1) + a));

shift5 = t5B - t5A;
shift24 = t24B - t24A;

% plot the reaching angles
subplot(2,3,4)
hold on

plot((1:81)+shift5,-m5A,'-k')
plot((1:81)+shift5,-(m5A-s5A),'--k')
plot((1:81)+shift5,-(m5A+s5A),'--k')
plot(1:80,-m5B,'-b')
plot(1:80,-(m5B-s5B),'--b')
plot(1:80,-(m5B+s5B),'--b')
ylabel('reach angle (deg)')
xlabel('epoch number')
xlim([1,100])
ylim([-32,32])
ax = gca;
ax.TickDir = 'out';
ax.YTick = -30 : 10 : 30;
ax.XTick = [1,20:20:80];

subplot(2,3,5)
hold on
plot((1:81)+shift24,-m24A,'-k')
plot((1:81)+shift24,-(m24A-s24A),'--k')
plot((1:81)+shift24,-(m24A+s24A),'--k')
plot(1:80,-m24B,'-b')
plot(1:80,-(m24B-s24B),'--b')
plot(1:80,-(m24B+s24B),'--b')
xlabel('epoch number')
xlim([1,100])
ylim([-32,32])
ax = gca;
ax.YTick = -30 : 10 : 30;
ax.XTick = [1,20:20:80];
ax.TickDir = 'out';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% plot rate comparison %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(2,3,6)
hold on
plot(ones(size(lerner5)),lerner5,'.g')
plot(2*ones(size(E5)),E5,'.b')
plot(4*ones(size(lerner24)),lerner24,'.g')
plot(5*ones(size(E24)),E24,'.b')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 0.5 : 2;
ylabel('learning rate in B / A')

subplot(2,3,3)
hold on
m = mean(lerner5);
s = std(lerner5) / sqrt(length(lerner5));
bar(1,m,'FaceColor','g','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = mean(E5);
bar(2,m,'FaceColor','b','EdgeColor','k')
s = std(E5) / sqrt(length(E5));
plot([2,2],[m-s,m+s],'-k')
m = mean(lerner24);
bar(4,m,'FaceColor','g','EdgeColor','k')
s = std(lerner24) / sqrt(length(lerner24));
plot([4,4],[m-s,m+s],'-k')
m = mean(E24);
bar(5,m,'FaceColor','b','EdgeColor','k')
s = std(E24) / sqrt(length(E24));
plot([5,5],[m-s,m+s],'-k')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 0.2 : 1;
ylabel('learning rate in B / A')
title('Figure 9C')