% the number of subjects
S = 30;

% range in implicit learning parameters
aRange = 0.05;
aMean = 0.925;
bRange = 0.1;
bMean = 0.25;

% iterate through many iterations
Niters = 40000;

% the number of total trials
Ntotal = 40;

% the rotation size
r = 30;

% mean of explicit learning
meanExplicit = 10;

% subject-to-subject variability in the explicit process
sigmaExplicit = linspace(0.1,8,40);

% the motor variability on each trial
sigmaMotorMean = 12;
sigmaMotorSTD = 6;

% the number of probe trials
Nprobe = 40;

% outputs for each probe number
outputTI = nan(length(sigmaExplicit),5);
outputTE = nan(length(sigmaExplicit),5);
outputEI = nan(length(sigmaExplicit),5);

% iterate through each
parfor s = 1 : length(sigmaExplicit)
    [outputTI(s,:),outputTE(s,:),outputEI(s,:)] = ...
        runSimulation(S,sigmaMotorMean,sigmaMotorSTD,Ntotal,Nprobe,Nprobe,...
        aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit(s),Niters);
end

% plot each probability in a different color
figure
hold on
plot(sigmaExplicit,outputTI(:,1),'-r')
plot(sigmaExplicit,outputTI(:,2),'-k')
plot(sigmaExplicit,outputTI(:,3),'-g')
ylabel('probability')
xlabel('sub-sub e var')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaExplicit(1),sigmaExplicit(end)])

save('explicit-variability-analysis','outputTI','outputTE','outputEI','sigmaExplicit');
