% the number of subjects
S = 30;

% range in implicit learning parameters
aRange = 0.05;
aMean = 0.925;
bRange = 0.1;
bMean = 0.25;

% iterate through many iterations
Niters = 40000;

% the number of total trials
Ntotal = 40;

% the rotation size
r = 30;

% mean of explicit learning
meanExplicit = 10;

% subject-to-subject variability in the explicit process
sigmaExplicit = 6;

% the motor variability on each trial
sigmaMotorMean = 12;
sigmaMotorSTD = 6;

% the number of probe trials
Nprobe = 1 : 80;

% outputs for each probe number
outputTI = nan(length(Nprobe),5);
outputTE = nan(length(Nprobe),5);
outputEI = nan(length(Nprobe),5);

% iterate through each
parfor s = 1 : length(Nprobe)
    [outputTI(s,:),outputTE(s,:),outputEI(s,:)] = ...
        runSimulation(S,sigmaMotorMean,sigmaMotorSTD,Ntotal,Nprobe(s),Nprobe(s),...
        aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit,Niters);
end

% plot each probability in a different color
figure
hold on
plot(Nprobe,outputTI(:,1),'-r')
plot(Nprobe,outputTI(:,2),'-k')
plot(Nprobe,outputTI(:,3),'-g')
ylabel('probability')
xlabel('num aftereffect trials')
ax = gca;
ax.TickDir = 'out';
xlim([Nprobe(1),Nprobe(end)])

save('probe-trial-analysis','outputTI','outputTE','outputEI','Nprobe');