% the number of subjects
S = 30;

% range in implicit learning parameters
aRange = 0.05;
aMean = 0.925;
bRange = 0.1;
bMean = 0.25;

% iterate through many iterations
Niters = 40000;

% the number of total trials
Ntotal = 40;

% the rotation size
r = 30;

% mean of explicit learning
meanExplicit = linspace(0,20,40);

% subject-to-subject variability in the explicit process
sigmaExplicit = 6;

% the motor variability on each trial
sigmaMotorMean = 12;
sigmaMotorSTD = 6;

% the number of probe trials
Nprobe = 40;

% outputs for each probe number
outputTI = nan(length(meanExplicit),5);
outputTE = nan(length(meanExplicit),5);
outputEI = nan(length(meanExplicit),5);

% iterate through each
parfor s = 1 : length(meanExplicit)
    [outputTI(s,:),outputTE(s,:),outputEI(s,:)] = ...
        runSimulation(S,sigmaMotorMean,sigmaMotorSTD,Ntotal,Nprobe,Nprobe,...
        aRange,aMean,bRange,bMean,r,meanExplicit(s),sigmaExplicit,Niters);
end

% plot each probability in a different color
figure
hold on
plot(meanExplicit,outputTI(:,1),'-r')
plot(meanExplicit,outputTI(:,2),'-k')
plot(meanExplicit,outputTI(:,3),'-g')
ylabel('probability')
xlabel('amt explicit')
ax = gca;
ax.TickDir = 'out';
xlim([meanExplicit(1),meanExplicit(end)])

save('total-explicit-analysis','outputTI','outputTE','outputEI','meanExplicit');