function [] = figure5()

% load the data
dd = load('data.mat');
I = dd.I;
E = dd.E;
T = dd.T;

% plot implicit vs. total
figure
subplot(3,3,9)
hold on
plot(I,T,'.k')
p = polyfit(I,T,1);
yfit = polyval(p,I);
plot(I,yfit,'-','Color',[75 54 33]/255)
xlabel('implicit angle (deg)')
ylabel('total adaptation (deg)')
ax = gca;
ax.TickDir = 'out';
title('Figure 5H')

% plot explicit vs. total
subplot(3,3,7)
hold on
plot(E,T,'.k')
p = polyfit(E,T,1);
yfit = polyval(p,E);
plot(E,yfit,'-','Color',[75 54 33]/255)
xlabel('explicit angle (deg)')
ylabel('total adaptation (deg)')
ax = gca;
ax.TickDir = 'out';
title('Figure 5G')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% simulate model predictions %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% seed the randon number generator
% note that results will not exactly match paper, due to randomness
rng(3)

% load data to run simulations
dd = load('data-simulations.mat');
I = dd.I;
E = dd.E;
T = dd.T;
R = 30*ones(size(T));

% fit a comp model to data
ipredict = @(p,e,r) p*(r-e);
costfun = @(p,e,r,i) sum((i - ipredict(p,e,r)).^2);
pComp = fminbnd(@(x)costfun(x,E,R,I),0,1);

% fit an SPE model to data
epredict = @(p,i,r) p*(r-i);
costfun = @(p,e,r,i) sum((e - epredict(p,i,r)).^2);
pInd = fminbnd(@(x)costfun(x,E,R,I),0,1);

% implicit and explicit mean and SD for simulations
Imean = mean(I);
Emean = mean(E);
Estd = 4;
Istd = 4;
Mstd = 2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% simulate 100 points using the competition model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
e = normrnd(Emean,Estd,250,1);
i = ipredict(pComp,e,30*ones(size(e)));

% get the measurements by adding noise
eMeasure = e + normrnd(0,Mstd,size(e));
iMeasure = i + normrnd(0,Mstd,size(i));
tMeasure = i + e + normrnd(0,Mstd,size(i));

% plot the results
subplot(3,3,4)
confidenceEllipse(eMeasure,iMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 5D')

subplot(3,3,5)
confidenceEllipse(eMeasure,tMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('total adaptation (deg)')
xlabel('explicit angle (deg)')
title('Figure 5E')

subplot(3,3,6)
confidenceEllipse(iMeasure,tMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('total adaptation (deg)')
xlabel('implicit angle (deg)')
title('Figure 5F')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% simulate 100 points using the SPE model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = normrnd(Imean,Istd,250,1);
e = epredict(pInd,i,30*ones(size(e)));

% get the measurements by adding noise
eMeasure = e + normrnd(0,Mstd,size(e));
iMeasure = i + normrnd(0,Mstd,size(i));
tMeasure = i + e + normrnd(0,Mstd,size(i));

% plot the results
subplot(3,3,1)
confidenceEllipse(eMeasure,iMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 5A')

subplot(3,3,2)
confidenceEllipse(eMeasure,tMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('total adaptation (deg)')
xlabel('explicit angle (deg)')
title('Figure 5B')

subplot(3,3,3)
confidenceEllipse(iMeasure,tMeasure)
ax = gca;
ax.TickDir = 'out';
ylabel('total adaptation (deg)')
xlabel('implicit angle (deg)')
title('Figure 5C')
