function [] = figure4C(fHandle)

% load the data
dd = load('dataE2.mat');
imeasured = dd.I;
emeasured = dd.E;

% fit the best Gaussian model (both generalization slope and implicit
% learning gain
pars = fit_gauss_2par(imeasured,emeasured,30*ones(size(imeasured)));

% plot the result (this is the TRUE generalization that would be needed to
% produce the data with SPE generalization alone)
figure(fHandle)
subplot(3,6,5)
hold on
xess = linspace(0,120,250);
xiss = pars(1)*30*exp(-0.5*(xess/pars(2)).^2);
xiss = xiss / max(xiss) * 100;
plot(xess,xiss,'-','Color',[166 123 91]/255)
ax = gca;
ax.TickDir = 'out';
xlim([0,120])
ax.XTick = 0 : 20 : 120;

% load literature generalization curves
d = load('data-literature.mat');
MCXm = d.MCXm1; MCYm = d.MCYm1; MCYs = d.MCYs1;
plot(MCXm,MCYm,'-','Color',[205,127,50]/255)
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color',[205,127,50]/255)
end

MCXm = d.MCXm2; MCYm = d.MCYm2; MCYs = d.MCYs2;
plot(MCXm,MCYm,'-','Color','m')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','m')
end

MCXm = d.MCXm3; MCYm = d.MCYm3; MCYs = d.MCYs3;
plot(MCXm,MCYm,'-','Color','b')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','b')
end

MCXm = d.MCXm4; MCYm = d.MCYm4; MCYs = d.MCYs4;
plot(MCXm,MCYm,'-','Color','g')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','g')
end

MCXm = d.MCXm5; MCYm = d.MCYm5; MCYs = d.MCYs5;
plot(MCXm,MCYm,'-','Color','r')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','r')
end

MCXm = d.MCXm6; MCYm = d.MCYm6; MCYs = d.MCYs6;
plot(MCXm,MCYm,'-','Color','c')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','c')
end

ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (% total)')
xlabel('corrected explicit (deg)')
ax.YTick = 0:20:120;
ax.XTick = 0:20:120;
title('Figure 4C')

end