function [] = figure4C(fHandle)

% load the data
dd = load('dataE3.mat');
imeasured = dd.I;
emeasured = dd.E;

% fit the best Gaussian model (both generalization slope and implicit
% learning gain
pars = fit_gauss_2par(imeasured,emeasured,30*ones(size(imeasured)));

% plot the result (this is the TRUE generalization that would be needed to
% produce the data with SPE generalization alone)
figure(fHandle)
subplot(3,6,5)
hold on
xess = linspace(0,120,800);
xiss = pars(1)*30*exp(-0.5*(xess/pars(2)).^2);
xiss = xiss / max(xiss) * 100;
plot(xess,xiss,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([0,120])
ax.XTick = 0 : 20 : 120;

end