# LINTRE
# Assumes LINTRE is in path
# Requires phyx for pxs2phy: 

# convert from fasta to phylip, but also remove first line of phylip file for lintre format
# replace ambiguous amino acids with X
pxs2phy -s concat_aln.fa | sed 1d | sed 's/[BJZ]/X/g' > concat_aln.phylip
# reorder taxa
grep 'bflo' concat_aln.phylip > concat_aln_reorder.phy
grep -v 'bflo' concat_aln.phylip >> concat_aln_reorder.phy

# Full analysis allows testing for Callorhinchus vs. elasmobranchs, and whale shark vs. brownbanded bamboo shark
# To test for specific clades or lineages being slow requires certain taxon subsets.
# Prepare alignments for each comparison:

# Chondrichthyes vs. Gar
grep 'bflo\|cint\|pmar\|cmil\|ccar\|cpun\|rtyp\|stor\|locu' concat_aln_reorder.phy > chon_v_locu.phy

# Chondrichthyes vs. Coelacanth
grep 'bflo\|cint\|pmar\|cmil\|ccar\|cpun\|rtyp\|stor\|lcha' concat_aln_reorder.phy > chon_v_lcha.phy

# Chondrichthyes vs. Sarcopterygii
grep -v 'locu\|drer\|dnig\|mmol\|olat\|eluc\|gmor\|onil\|trub\|gacu\|sfor' concat_aln_reorder.phy > chon_v_sarc.phy

# Chondrichthyes vs. Actinopterygii
grep -v 'dnov\|bacu\|sscr\|xtro\|amis\|ggal\|acar\|hsap\|lafr\|ttru\|clup\|bmys\|btau\|mmus\|pcap\|mdom\|oana\|lcha' concat_aln_reorder.phy > chon_v_acti.phy

# Chondrichthyes vs. Tetrapoda
grep -v 'locu\|drer\|dnig\|mmol\|olat\|eluc\|gmor\|onil\|trub\|gacu\|sfor\|lcha' concat_aln_reorder.phy > chon_v_tetr.phy

# For each alignment, estimate genetic distances jusing njboot and perform two cluster test using tpcv
for i in `ls *phy | grep -v -f <(ls *tc | cut -f1 -d'.')`; do j=`echo "$i" | cut -f1 -d'.'`; njboot "$i" -d6 > "$j".nj6; tpcv "$i" -t"$j".nj6 -d3 -o 1 > "$j".tc; done
