
clear all; close all

load Figure_3_source_data

conditions = {'control', 'UpStep', 'DownStep'};
numSubjects = 12;

for z = 1:length(conditions)
    figure; hold on
    meanStepTime = []; meanSpeed = []; %reset per condition
    for i = 1:numSubjects         
        timeTemp = dataElife.(conditions{z}).time{i};
        speedTemp = dataElife.(conditions{z}).speed{i};
        plot(timeTemp, speedTemp)
        meanStepTime = [meanStepTime mean(timeTemp, 2)];
        meanSpeed =    [meanSpeed mean(speedTemp,2)];
    end
    plot([0 0], ylim, 'k--')
    ylabel('speed (m/s)'); xlabel('time(s)'); title(strcat(conditions{z},' all trials'))

    figure; hold on; plot( meanStepTime,  meanSpeed, 'linewidth', 2); 
    plot([0 0], ylim, 'k--')
    ylabel('speed (m/s)'); xlabel('time(s)'); title(strcat(conditions{z},' averages'))
end