function [shuffle] = NetShuffle(S_bin,tsscn,running,numit)
%%

thresh = 3:15; %Assumed possible number of cells per network

for i = 1:length(thresh)
    network = NetEvents(S_bin,tsscn,running,thresh(i));
    a(i,:) = network.netfreq(1,:);
end

netfreq = a;
a = find(a(:,1),1,'last');
thresh = thresh(1:a);
netfreq = netfreq(1:a,:);
%%
networkshuffle = zeros(numit,3,length(thresh));

parfor i = 1:numit
    %%   
    S_rand = ShuffleData(S_bin);
    nstemp = zeros(3,length(thresh));
    for j = 1:length(thresh)
        network = NetEvents(S_rand,tsscn,running,thresh(i));
        if ~isempty(network.netfreq)
            nstemp(:,j) = network.netfreq(1,:);
        end
    end
    networkshuffle(i,:,:) = nstemp;
end

%% fit network p

pnet = zeros(3,length(thresh));
a = zeros(length(thresh),3);
b = zeros(length(thresh),3);
for i = 1:length(thresh)
    network = NetEvents(S_bin,tsscn,running,thresh(i));
    a(i,:) = network.netfreq(1,:);
    b(i,:) = mean(networkshuffle(:,:,i));
    
    pnet(1,i) = sum(a(i,1)<=networkshuffle(:,1,i))/numit;
    pnet(2,i) = sum(a(i,2)<=networkshuffle(:,2,i))/numit;
    pnet(3,i) = sum(a(i,3)<=networkshuffle(:,3,i))/numit;
    for j = 1:3
        if i>1 && pnet(j,i)>=.05 && pnet(j,i)>pnet(j,i-1)
            pnet(j,1:i-1) = 1;
        end
    end
end
%%
pnet = [pnet; thresh];
a = find(pnet(1,:)<.05,1)+1;
if isempty(a);a = 2;end
thresh = thresh(a);


NEshufMean = permute(mean(networkshuffle,1),[3 2 1]);
NEshufStd = permute(std(networkshuffle,0,1),[3 2 1]); 
shuffleDist = networkshuffle(:,:,a);

%% output

shuffle.shuffleDist = shuffleDist;
shuffle.pnet = pnet;
shuffle.netthresh = thresh;
shuffle.networkshuffle = networkshuffle;
shuffle.NEfreq = netfreq;
shuffle.NEshufMean = NEshufMean;
shuffle.NEshufStd = NEshufStd;


end

function S_rand = ShuffleData(S_bin)

    S_rand = zeros(size(S_bin));
    % shuffle everything
    for j = 1:size(S_bin,1)
        a = randperm(size(S_bin,2));
        S_rand(j,:) = S_bin(j,a);
    end
    
    % shift traces randomly with respect to each other
%     for j = 1:size(S_bin,1)
%         a = randperm(size(S_bin,2),1);
%         S_rand(j,:) = S_bin(j,[a:size(S_bin,2) 1:a-1]);
%     end
    
end
