library("rstan")
library("rethinking")
library("truncnorm")

rstan_options(auto_srite = TRUE)
options(mc.cores = parallel::detectCores())
Sys.setenv(STAN_NUM_THREADS = -1)

source("model_input.R")

### Initial values ###
initf <- function() {
  lkj_cor_m_s=rlkjcorr(n=1,K=n_RndEffs,eta=5)
  L_s = chol(lkj_cor_m_s)
  z_s=matrix(rtruncnorm(n_RndEffs*n_strains,a=-0.5, b=0.5, mean = 0, sd = 1), nrow=n_RndEffs)
  
  lkj_cor_m_u=rlkjcorr(n=1,K=n_RndEffs,eta=5)
  L_u = chol(lkj_cor_m_u)
  z_u=matrix(rtruncnorm(n_RndEffs*n_mice,a=-0.5, b=0.5, mean = 0, sd = 1), nrow=n_RndEffs)
  
  list(
    muR_dash = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    muR_dash2 = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    rho = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    psi_N1 = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    psi_N2 = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    beta = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    sd_s = rtruncnorm(n_RndEffs, a=0.0, b= 0.5, mean = 0, sd = 1), 
    sd_u = rtruncnorm(n_RndEffs, a=0.0, b= 0.5, mean = 0, sd = 1), 
    z_s = z_s,
    z_u = z_u,
    L_s = L_s,
    L_u = L_u,
    sd_RBC = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1),
    sd_iRBC = rtruncnorm(1, a=-0.5, b=0.5, mean = 0, sd = 1)
  )
} 

n_chains=4
inits <- lapply(1:n_chains, function(id) initf())

output1 <- stan(file = 'model_fit.stan',
                data = model_input,
                chains = n_chains, init = inits,
                iter =4000,warmup=1000,
                control = list(max_treedepth = 10,adapt_delta=0.99),
                save_warmup=FALSE)

save(file="output1.rda",output1)
quit(save="no")
