library(survival)

resilience_levels <- c('PWK/PhJ','A/J','NOD/ShiLtJ','CAST/EiJ','C57BL/6','NZO/HILtJ','129S1/SvImJ','WSB/EiJ') #set by average survival across experiments
res_cols=c(rgb(171/255, 8/255, 38/255,alpha=1),
           rgb(230/255, 100/255, 0/255,alpha=1),
           rgb(255/255, 204/255, 0/255,alpha=1),
           rgb(158/255, 226/255, 27/255,alpha=1),
           rgb(31/255, 204/255, 129/255,alpha=1),
           rgb(50/255, 200/255, 255/255,alpha=1),
           rgb(10/255, 100/255, 225/255,alpha=1),
           rgb(0/255, 30/255, 120/255,alpha=1)) 

survData = read.csv("survival.csv")
survData$Strain <- factor(survData$Strain, levels = resilience_levels)

fit <- survfit(Surv(DeathDay, Died.) ~ Strain, data = survData)


par(mfrow=c(1,2),mar=c(5,5,1,1))
plot(fit,
     xlim=c(0,15),
     col=res_cols,lwd=2,axes=F,xlab="Day post infection",ylab="Survival", yaxs="i", xaxs="i")
axis(1,las=1,at=c(0,5,10,15),tck=-0.01)
axis(2,las=1,tck=-0.01)
plot(NA,ylim=c(0,1),xlim=c(0,1),axes=F,xlab=NA,ylab=NA)
legend(x=0,y=1,rev(resilience_levels),col=rev(res_cols),bty = "n",border = "n",text.col=rev(res_cols))

