library("lattice")
library("gridExtra")

source("model_input.R")

cols=c(rgb(39/255, 174/255, 235/255,alpha=1),
       rgb(231/255, 111/255, 11/255,alpha=1),
       rgb(31/255, 204/255, 129/255,alpha=1),
       rgb(158/255, 226/255, 27/255,alpha=1),
       rgb(238/255, 223/255, 81/255,alpha=1),
       rgb(50/255, 148/255, 246/255,alpha=1),
       rgb(171/255, 8/255, 38/255,alpha=1),
       rgb(27/255, 69/255, 226/255,alpha=1)) 

mouse_strains=c("129S1/SvImJ","A/J","C57BL/6","CAST/EiJ","NOD/ShiLtJ","NZO/HILtJ","PWK/PhJ","WSB/EiJ")

mouseList = c(71:80,1:10,51:60,21:30,31:40,41:50,11:20,61:70)

colList = c(
  rep(rgb(39/255, 174/255, 235/255,alpha=1),10),
  rep(rgb(231/255, 111/255, 11/255,alpha=1),10),
  rep(rgb(31/255, 204/255, 129/255,alpha=1),10),
  rep(rgb(158/255, 226/255, 27/255,alpha=1),10),
  rep(rgb(238/255, 223/255, 81/255,alpha=1),10),
  rep(rgb(50/255, 148/255, 246/255,alpha=1),10),
  rep(rgb(171/255, 8/255, 38/255,alpha=1),10),
  rep(rgb(27/255, 69/255, 226/255,alpha=1),10)) 

########################### Plotting ###########################
par(mfrow=c(1,11),oma=c(4,4,1,0),mar=c(4,4,2,5))
layout.matrix <- t(matrix(c(1,1,2,2,
                            1,1,2,2,
                            3,4,5,6,
                            7,8,9,10), 
                          nrow = 4, ncol = 4)) # nrow is actually ncol, vice versa
layout(mat = layout.matrix,
       heights = c(1,1,1,1), # Heights of the  rows
       widths = c(1,1,1,1)) # Widths of the columns
layout.show(10)
plot(NA,xlim=c(0,3000000),ylim=c(0,1.1e7),axes=F,xlab=NA,ylab=NA, yaxs="i", xaxs="i")
axis(1,las=1,tck=F,cex.axis=0.8,labels=F)
axis(2,las=1,tck=F,cex.axis=0.8,labels=F)
mtext("Parasite burden (iRBC)",side=1,line=1,cex=0.8)
mtext("Host health (RBC)",side=2,line=1,cex=0.8)
mtext(do.call(expression, list(bquote("Common trajectories in "),bquote("rodent malaria infections"))),
      side=3,line=1.5:0.5,cex=1)

par(mar=c(4,4,2,5))
plot(NA,xlim=c(0,3000000),ylim=c(0,1.1e7),axes=F,xlab=NA,ylab=NA, yaxs="i", xaxs="i")
axis(1,las=1,tck=-0.01,cex.axis=0.8,at=c(0,1000000,2000000,3000000))
axis(2,las=1,cex.axis=0.8,tck=-0.01)
mtext("RBC",side=2,line=3.2,cex=0.8)
mtext("iRBC",side=1,line=2.5,cex=0.8)
mtext("Median trajectory per mouse strain",
      side=3,line=1,cex=1)

y_RBC_strain_aves = y_iRBC_strain_aves = matrix(NA,nrow=n_strains,ncol=n_ds)
for(s in 1:n_strains){
  for(d in 1:n_ds){
    y_RBC_strain_aves[s,d] = median(y_RBC[strain==s & day == d],na.rm = T)
    y_iRBC_strain_aves[s,d] = median(y_iRBC[strain==s & day == d],na.rm = T)
  } 
}

for(s in 1:n_strains){
  plotted=setdiff(1:n_ds,which(y_iRBC_strain_aves[s,]==0))
  points(y_iRBC_strain_aves[s,plotted],y_RBC_strain_aves[s,plotted],type="l",lwd=1.5,col=cols[s])
}

par(mar=c(0,1,0,0.25))
for(i in mouseList){
  if(i %in% (seq(0,80,10)+1)){
    plot(NA,xlim=c(0,3000000),ylim=c(0,1.1e7),axes=F,xlab=NA,ylab=NA, yaxs="i", xaxs="i")
    if(i == 1) text("129S1/SvImJ",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 11) text("A/J",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 21) text("C57BL/6",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 31) text("CAST/EiJ",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 41) text("NOD/ShiLtJ",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 51) text("NZO/HILtJ",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 61) text("PWK/PhJ",cex=1,x=2.9e6,y=1e6,pos=2)
    if(i == 71) text("WSB/EiJ",cex=1,x=2.9e6,y=1e6,pos=2)
    
    if(i == 31){
      axis(1,las=1,tck=-0.01,cex.axis=0.8,at=c(0,1000000,2000000,3000000))
      axis(2,las=1,tck=-0.01,cex.axis=0.8)
      mtext("iRBC",side=1,line=2.5,cex=0.8)
      mtext("RBC",side=2,line=3.2,cex=0.8)
    } else{
      axis(1,las=1,tck=-0.01,cex.axis=0.8,at=c(0,1000000,2000000,3000000),label=F)
      axis(2,las=1,tck=-0.01,cex.axis=0.8,label=F)
    }
  }
  
  plotted=setdiff(1:n_ds,which(y_iRBC[mouse==i][1:n_ds]==0))
  points(y_iRBC[mouse==i][plotted],y_RBC[mouse==i][plotted],type="l",lwd=1,col=colList[i])
}

