library("rstan")
library("lattice")
library("gridExtra")
library("devtools")
library("ggbiplot")

load("output1.rda")
extracted_output=rstan::extract(output1)

source("model_input.R")

cols=c(rgb(10/255, 100/255, 225/255,alpha=1),
       rgb(230/255, 100/255, 0/255,alpha=1),
       rgb(31/255, 204/255, 129/255,alpha=1),
       rgb(158/255, 226/255, 27/255,alpha=1),
       rgb(255/255, 204/255, 0/255,alpha=1),
       rgb(50/255, 200/255, 255/255,alpha=1),
       rgb(171/255, 8/255, 38/255,alpha=1),
       rgb(0/255, 30/255, 120/255,alpha=1)) 

dataset = as.data.frame(matrix(NA,nrow=n_mice,ncol=9))
colnames(dataset) = c("muR_dash","muR_dash2",
                      "rho",
                      "psi_N1","psi_N2",
                      "beta",
                      "strain","tag","status")

dataset$strain = c(rep("129S1/SvImJ",10),rep("A/J",10),rep("C57BL/6",10),rep("CAST/EiJ",10),
                   rep("NOD/ShiLtJ",10),rep("NZO/HILtJ",10),rep("PWK/PhJ",10),rep("WSB/EiJ",10))
dataset$tag = c(rep("h",10),rep("d",10),rep("g",10),rep("c",10),
                   rep("b",10),rep("f",10),rep("a",10),rep("e",10))
dataset$status = c(rep("Resilient",10),rep("Non-resilient",10),rep("Resilient",10),rep("Non-resilient",10),
                   rep("Non-resilient",10),rep("Resilient",10),rep("Non-resilient",10),rep("Resilient",10))

for(m in 1:n_mice){
  for(i in 1:n_RndEffs){
    dataset[m,i] = median(extracted_output$s[,i,strain_id[m]]+extracted_output$u[,i,m]) #median(extracted_output$theta[,m,i])
  }
}

pca.out <- prcomp(dataset[,-c(7,8,9)], center = TRUE,scale. = TRUE)
summary(pca.out)
ggbiplot(pca.out, obs.scale = 1, var.scale = 1, group=dataset$strain,
         alpha=0) + 
  geom_point(aes(colour=dataset$strain), size = 2) +
  scale_colour_manual(values= cols) + 
  theme_minimal() + theme(legend.position = "none")
