library("rstan")
library("lattice")
library("gridExtra")
library("tidyverse")

source("model_input.R")
load("output1.rda")
extracted_output=rstan::extract(output1)
data=read.csv("cytokines.csv")
head(data)

cols=c(rgb(10/255, 100/255, 225/255,alpha=1),
       rgb(230/255, 100/255, 0/255,alpha=1),
       rgb(31/255, 204/255, 129/255,alpha=1),
       rgb(158/255, 226/255, 27/255,alpha=1),
       rgb(255/255, 204/255, 0/255,alpha=1),
       rgb(50/255, 200/255, 255/255,alpha=1),
       rgb(171/255, 8/255, 38/255,alpha=1),
       rgb(0/255, 30/255, 120/255,alpha=1)) 


### Simulate the average infection dynamics per strain
expose_stan_functions("plot_simulate.stan")
thinned_index=floor(seq(1,length(extracted_output$rho),length.out=200))
n_rep = length(thinned_index)
n_var=4
storage=array(NA,dim=c(n_ds,n_var,n_mice,n_rep))

for(i in 1:length(thinned_index)){
  for(m in 1:n_mice){
    phi = c(extracted_output$phi[thinned_index[i],1],extracted_output$phi[thinned_index[i],2])
    x_i = c(n_ds=n_ds,
            n_Eq=n_Eq)
    x_r = c(max_iRBC = max_iRBC,
            kappa = kappa,
            muM = muM,
            R0 = R0[m],
            I0 = I0[m])
    theta = extracted_output$theta[thinned_index[i],m,]
    predictedFit=malaria_fit(phi,theta, x_r, x_i) #indexed as predictedFit[[time]][variable]
    
    for(t in 1:14){
      storage[t,1,m,i] = predictedFit[[t]][1] #N1[t]
      storage[t,2,m,i] = predictedFit[[t]][2] #N2[t] 
      storage[t,3,m,i] = rnorm(1,sum(predictedFit[[t]][3:4]),phi[1]) #R[t] with noise
      storage[t,4,m,i] = 10^(rnorm(1,log10(predictedFit[[t]][4]+1),phi[2])) #I[t]
      
    }
  }
}

lower = upper = median_outcome = array(NA,dim=c(n_ds,n_var,n_mice))
for(t in 1:n_ds){
  for(j in 1:n_var){
    for(m in 1:n_mice){
      lower[t,j,m]=quantile(storage[t,j,m,],0.025,na.rm = T)
      upper[t,j,m]=quantile(storage[t,j,m,],0.975,na.rm = T)
      median_outcome[t,j,m]=median(storage[t,j,m,],na.rm = T)
    }
  }
}

mice = unique(mouse)

#####
### Average per strain
# m == 1: "129S1/SvImJ"
# m == 11: "A/J"
# m == 21: "C57BL/6"
# m == 31: "CAST/EiJ"
# m == 41: "NOD/ShiLtJ"
# m == 51: "NZO/HILtJ"
# m == 61: "PWK/PhJ"
# m == 71: "WSB/EiJ"

mouse_strains=c("129S1/SvImJ","A/J","C57BL/6","CAST/EiJ","NOD/ShiLtJ","NZO/HILtJ","PWK/PhJ","WSB/EiJ")
mouse_index = c(1,11,21,31,41,51,61,71)
median_N1 = rep(NA,nrow(data))
median_N2 = rep(NA,nrow(data))
median_iRBC = rep(NA,nrow(data))
data=cbind(data,median_N1,median_N2,median_iRBC)

for(d in 3:9){
  for(m in 1:8){
    temp_N1 = rep(NA,10)
    temp_N2 = rep(NA,10)
    temp_iRBC = rep(NA,10)
    for(i in 1:10){
      temp_N1[i] = median_outcome[d,1,mouse_index[m]+i-1] 
      temp_N2[i] = median_outcome[d,2,mouse_index[m]+i-1] 
      temp_iRBC[i] = median_outcome[d,4,mouse_index[m]+i-1] 
    }
    data[data$Day==d & data$Strain==mouse_strains[m] ,"median_N1"] = median(temp_N1)
    data[data$Day==d & data$Strain==mouse_strains[m] ,"median_N2"] = median(temp_N2)
    data[data$Day==d & data$Strain==mouse_strains[m] ,"median_iRBC"] = median(temp_iRBC)
  }
}

data$grp <- paste0(data$Strain,"_",data$Day)

mean_over_time <- data %>%
  group_by(grp) %>%
  summarise_all(mean, na.rm = TRUE) %>%
  separate(grp,c("Strain", "Day"),"_") %>%
  mutate(Mouse.ID = NULL)

####
par(oma=c(2.5,8,7,4),mar=c(2,3,0,0))
layout.matrix <- matrix(t(c(c(1,2,3,4),
                            c(2,6,7,8),
                            c(3,10,11,12),
                            c(43,0,0,0))), 
                          nrow = 4, ncol = 4) # nrow is actually ncol, vice versa

layout.matrix <- t(matrix(c(c(1,5, 9),
                            c(2,6, 10),
                            c(3,7, 11),
                            c(4,8, 12),
                            c(13,13,0),
                            c(13,13,0)), 
                          nrow = 3, ncol = 6))

layout(mat = layout.matrix,
       heights = rep(1,6), # Heights of the  rows
       widths =  rep(1,3)) # Widths of the two columns

layout.show(13)

### Uninfected 
# TNFA
x_offset = seq(-0.25,0.25,length.out = 8)
plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"TNFA"],na.rm=T)),log(max(data[,"TNFA"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==FALSE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$TNFA),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$TNFA),na.rm=T)-sd(log(temp_strain$TNFA),na.rm=T),
               y1=mean(log(temp_strain$TNFA),na.rm=T)+sd(log(temp_strain$TNFA),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("a. Raw expression \n in uninfected mice",side=3,line=1)
mtext("ln(fluorescence intensity)",side=2,cex=0.75,line=2.5)
mtext(expression(paste("TNF-", alpha)),side=2, line=5.5,las=1)

# IFNG
plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"IFNG"],na.rm=T)),log(max(data[,"IFNG"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==FALSE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$IFNG),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$IFNG),na.rm=T)-sd(log(temp_strain$IFNG),na.rm=T),
               y1=mean(log(temp_strain$IFNG),na.rm=T)+sd(log(temp_strain$IFNG),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext(expression(paste("IFN-", gamma)),side=2, line=5.5,las=1)
mtext("Pro-inflammatory",side=2, line=9)

# IL10
plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"IL10"],na.rm=T)),log(max(data[,"IL10"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==FALSE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$IL10),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$IL10),na.rm=T)-sd(log(temp_strain$IL10),na.rm=T),
               y1=mean(log(temp_strain$IL10),na.rm=T)+sd(log(temp_strain$IL10),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext(expression(paste("IL-10")),side=2, line=5.5,las=1)

# TGFB
plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"TGFB"],na.rm=T)),log(max(data[,"TGFB"],na.rm=T))),axes=F)
axis(1,las=1); axis(2,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==FALSE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$TGFB),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$TGFB),na.rm=T)-sd(log(temp_strain$TGFB),na.rm=T),
               y1=mean(log(temp_strain$TGFB),na.rm=T)+sd(log(temp_strain$TGFB),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext(expression(paste("TGF-", beta)),side=2, line=5.5,las=1)
mtext("Anti-inflammatory",side=2, line=9)
mtext("Day-post infection",side=1, line=2.5,las=1,cex=0.75)

### Infected
plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"TNFA"],na.rm=T)),log(max(data[,"TNFA"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1,labels=F);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$TNFA),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$TNFA),na.rm=T)-sd(log(temp_strain$TNFA),na.rm=T),
               y1=mean(log(temp_strain$TNFA),na.rm=T)+sd(log(temp_strain$TNFA),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("b. Raw expression \n in infected mice",side=3,line=1)

plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"IFNG"],na.rm=T)),log(max(data[,"IFNG"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1,labels=F);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$IFNG),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$IFNG),na.rm=T)-sd(log(temp_strain$IFNG),na.rm=T),
               y1=mean(log(temp_strain$IFNG),na.rm=T)+sd(log(temp_strain$IFNG),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}

plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"IL10"],na.rm=T)),log(max(data[,"IL10"],na.rm=T))),axes=F)
axis(1,las=1,labels=F); axis(2,las=1,labels=F);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$IL10),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$IL10),na.rm=T)-sd(log(temp_strain$IL10),na.rm=T),
               y1=mean(log(temp_strain$IL10),na.rm=T)+sd(log(temp_strain$IL10),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}


plot(NA,xlim=c(2.7,9.3),
     ylab=NA,
     xlab=NA,
     ylim=c(log(min(data[,"TGFB"],na.rm=T)),log(max(data[,"TGFB"],na.rm=T))),axes=F)
axis(1,las=1); axis(2,las=1,labels=F);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log(temp_strain$TGFB),na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log(temp_strain$TGFB),na.rm=T)-sd(log(temp_strain$TGFB),na.rm=T),
               y1=mean(log(temp_strain$TGFB),na.rm=T)+sd(log(temp_strain$TGFB),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("Day-post infection",side=1, line=2.5,las=1,cex=0.75)

#### iRBC-scaled
plot(NA,xlim=c(2.7,9.3),ylim=c(0,max(data$TNFA/data$median_iRBC,na.rm=T)),
     xlab=NA,
     ylab=NA,axes=F)
axis(1,las=1,labels=F); axis(4,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(temp_strain$TNFA/temp_strain$median_iRBC,na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(temp_strain$TNFA/temp_strain$median_iRBC,na.rm=T)-sd(temp_strain$TNFA/temp_strain$median_iRBC,na.rm=T),
               y1=mean(temp_strain$TNFA/temp_strain$median_iRBC,na.rm=T)+sd(temp_strain$TNFA/temp_strain$median_iRBC,na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("iRBC-scaled intensity", side=4,cex=0.75, line=3)
mtext("c. iRBC-scaled expression \n in infected mice",side=3, line=1)

plot(NA,xlim=c(2.7,9.3),ylim=c(0,max(data$IL10/data$median_iRBC,na.rm=T)),
     xlab=NA,
     ylab=NA,axes=F)
axis(1,las=1,labels=F); axis(4,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(temp_strain$IL10/temp_strain$median_iRBC,na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(temp_strain$IL10/temp_strain$median_iRBC,na.rm=T)-sd(temp_strain$IL10/temp_strain$median_iRBC,na.rm=T),
               y1=mean(temp_strain$IL10/temp_strain$median_iRBC,na.rm=T)+sd(temp_strain$IL10/temp_strain$median_iRBC,na.rm=T),
               col=cols[s],pch=16)
    }
  }
}

plot(NA,xlim=c(2.7,9.3),ylim=c(0,max(data$IFNG/data$median_iRBC,na.rm=T)),
     xlab=NA,
     ylab=NA,axes=F)
axis(1,las=1,labels=F); axis(4,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(temp_strain$IFNG/temp_strain$median_iRBC,na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(temp_strain$IFNG/temp_strain$median_iRBC,na.rm=T)-sd(temp_strain$IFNG/temp_strain$median_iRBC,na.rm=T),
               y1=mean(temp_strain$IFNG/temp_strain$median_iRBC,na.rm=T)+sd(temp_strain$IFNG/temp_strain$median_iRBC,na.rm=T),
               col=cols[s],pch=16)
    }
  }
}

plot(NA,xlim=c(2.7,9.3),ylim=c(0,max(data$TGFB/data$median_iRBC,na.rm=T)),
     xlab=NA,
     ylab=NA,axes=F)
axis(1,las=1); axis(4,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_strain=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(temp_strain$TGFB/temp_strain$median_iRBC,na.rm=T)~x_cord,col=cols[s],pch=16)
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(temp_strain$TGFB/temp_strain$median_iRBC,na.rm=T)-sd(temp_strain$TGFB/temp_strain$median_iRBC,na.rm=T),
               y1=mean(temp_strain$TGFB/temp_strain$median_iRBC,na.rm=T)+sd(temp_strain$TGFB/temp_strain$median_iRBC,na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("Day-post infection",side=1, line=2.5,las=1,cex=0.75)

# Expression balance
par(mar=c(2,3,6,0))
plot(NA,xlim=c(2.7,9.3),ylim=c(-1.5,2.5),
     xlab=NA,
     ylab=NA,axes=F)
axis(1,las=1); axis(2,las=1);box()
for(s in c(8,1,6,3,4,5,2,7)){
  for(d in 3:9){
    temp_infected=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==TRUE,]
    temp_control=data[data$Strain==unique(data$Strain)[s] & data$Day==d & data$Status==FALSE,]
    x_cord = (d+x_offset[order(c(8,1,6,3,4,5,2,7))[s]])
    points(mean(log((temp_infected$TNFA+temp_infected$IFNG)/(temp_infected$IL10+temp_infected$TGFB)),na.rm=T)~x_cord,col=cols[s],pch=16)
    
    if(nrow(temp_strain)>1){
      segments(x0=x_cord,x1=x_cord,
               y0=mean(log((temp_infected$TNFA+temp_infected$IFNG)/(temp_infected$IL10+temp_infected$TGFB)),na.rm=T)-sd(log((temp_infected$TNFA+temp_infected$IFNG)/(temp_infected$IL10+temp_infected$TGFB)),na.rm=T),
               y1=mean(log((temp_infected$TNFA+temp_infected$IFNG)/(temp_infected$IL10+temp_infected$TGFB)),na.rm=T)+sd(log((temp_infected$TNFA+temp_infected$IFNG)/(temp_infected$IL10+temp_infected$TGFB)),na.rm=T),
               col=cols[s],pch=16)
    }
  }
}
mtext("d. Expression balance",side=3, line=1,las=1)
mtext("Day-post infection",side=1, line=2.5,las=1,cex=0.75)
mtext("Pro- / anti-inflammatory ratio",side=2, line=2,cex=0.75)

