library("rstan")
library("tidyverse")
library("bayesplot")

### Load data and output ###
source("model_input.R")
load("model_input_post_mean.rda")

load("output1.rda")
load("output2.rda")

load("post_mean1_fixed.rda")
load("post_sd1_fixed.rda")

load("post_mean1_theta.rda")
load("post_sd1_theta.rda")

load("post_mean1_sd_s.rda")
load("post_sd1_sd_s.rda")
load("post_mean1_sd_u.rda")
load("post_sd1_sd_u.rda")

load("post_mean1_mean_phi.rda")
load("post_mean1_sd_phi.rda")

summaryOutput1=summary(output1)
summaryOutput2=summary(output2)

extracted_output1=rstan::extract(output1)
extracted_output2=rstan::extract(output2)

### Divergence ###
divergent1 <- get_sampler_params(output1, inc_warmup=FALSE)[[1]][,'divergent__']
sum(divergent1)
divergent2 <- get_sampler_params(output2, inc_warmup=FALSE)[[1]][,'divergent__']
sum(divergent2)

### n_eff and Rhat ###
summaryOutput=summary(output1)
n_eff=summaryOutput$summary[,"n_eff"]
head(sort(n_eff),30)

rhat=summaryOutput$summary[,"Rhat"]
head(sort(rhat,decreasing = TRUE),30)

summaryOutput=summary(output2)
n_eff=summaryOutput$summary[,"n_eff"]
head(sort(n_eff),30)

rhat=summaryOutput$summary[,"Rhat"]
head(sort(rhat,decreasing = TRUE),30)

### Parameter correlations ###
round(cor(cbind(extracted_output1$muR_dash,
                extracted_output1$muR_dash2,
                extracted_output1$rho,
                extracted_output1$psi_N1,
                extracted_output1$psi_N2,
                extracted_output1$beta)),3)

thinned_index=floor(seq(1,length(extracted_output1$muR_dash),length.out=1000))

pars = as.data.frame(cbind(extracted_output1$muR_dash[thinned_index],
              extracted_output1$muR_dash2[thinned_index],
              extracted_output1$rho[thinned_index],
              extracted_output1$psi_N1[thinned_index],
              extracted_output1$psi_N2[thinned_index],
              extracted_output1$beta[thinned_index],
              extracted_output1$omega[thinned_index]))
colnames(pars) = c("muR_dash","muR_dash2","rho",
                   "psi_N1", "psi_N2",
                   "beta")
      
mcmc_pairs(pars,pars = colnames(pars),off_diag_args = list(size=2,alpha=0.5))

### Posterior z-score and post contraction
post_mean2_fixed = post_sd2_fixed = rep(NA,n_RndEffs)

post_mean2_fixed[1] = mean(extracted_output2$muR_dash)
post_mean2_fixed[2] = mean(extracted_output2$muR_dash2)
post_mean2_fixed[3] = mean(extracted_output2$rho)
post_mean2_fixed[4] = mean(extracted_output2$psi_N1)
post_mean2_fixed[5] = mean(extracted_output2$psi_N2)
post_mean2_fixed[6] = mean(extracted_output2$beta)

post_sd2_fixed[1] = sd(extracted_output2$muR_dash)
post_sd2_fixed[2] = sd(extracted_output2$muR_dash2)
post_sd2_fixed[3] = sd(extracted_output2$rho)
post_sd2_fixed[4] = sd(extracted_output2$psi_N1)
post_sd2_fixed[5] = sd(extracted_output2$psi_N2)
post_sd2_fixed[6] = sd(extracted_output2$beta)

post_mean2_theta = post_sd2_theta = matrix(NA,nrow=n_RndEffs,ncol=n_mice)
for(m in 1:n_mice){
  post_mean2_theta[,m] = apply(extracted_output2$theta[,m,],2,mean)
  post_sd2_theta[,m] = apply(extracted_output2$theta[,m,],2,sd)
}

post_mean2_sd_s = apply(extracted_output2$sd_s,2,mean) 
post_sd2_sd_s = apply(extracted_output2$sd_s,2,sd)  
post_mean2_sd_u = apply(extracted_output2$sd_u,2,mean)
post_sd2_sd_u = apply(extracted_output2$sd_u,2,sd) 

post_mean2_mean_phi = apply(extracted_output2$phi,2,mean)
post_mean2_sd_phi = apply(extracted_output2$phi,2,sd)

post_z = function(post_mean2,post_mean1,post_sd2){
  z = (post_mean2-post_mean1)/post_sd2
  return(z)
}

post_contr = function(post_sd,prior_sd){
  contr = 1 - (post_sd^2/prior_sd^2)
  return(contr)
}

post_z_fixed = post_z_sd_s  = post_z_sd_u = rep(NA,nrow=n_RndEffs)
post_contr_fixed = post_contr_fsd_s = post_contr_sd_u = rep(NA,nrow=n_RndEffs)

post_z_fixed = post_z(post_mean2_fixed,post_mean1_fixed,post_sd2_fixed)
post_contr_fixed = post_contr(post_sd1_fixed,1)

post_z_sd_s = post_z(post_mean2_sd_s,post_mean1_sd_s,post_sd2_sd_s)
post_contr_sd_s = post_contr(post_sd1_sd_s,1)

post_z_sd_u = post_z(post_mean2_sd_u,post_mean1_sd_u,post_sd2_sd_u)
post_contr_sd_u = post_contr(post_sd1_sd_u,1)

post_z_contr = as_tibble(bind_cols(c(post_z_fixed,post_z_sd_s,post_z_sd_u),
                                   c(post_contr_fixed,post_contr_sd_s,post_contr_sd_u),
                                   c(rep("theta",n_RndEffs),rep("sd_s",n_RndEffs),rep("sd_u",n_RndEffs))))
colnames(post_z_contr) = c("post_z","post_contr","par")
post_z_contr = post_z_contr %>% 
  mutate(par = fct_relevel(par, "theta","sd_s","sd_u"))

ggplot(data = post_z_contr, mapping = aes(x = post_contr, y = post_z, colour = factor(par))) + 
  geom_point(shape=16) + 
  ylim(-4,4) +
  xlim(0,1) +
  xlab("Posterior contraction") +
  ylab("Posterior z-score") +
  labs(colour="Parameter type") +
  theme_bw()

