
functions {
    real[,] malaria_fit(real[] phi, real[] theta, real[] x_r, int[] x_i) {
    /*########## (DECLARE) ##########*/
    /*########## (declare) fixed  parameters ##########*/
    real max_iRBC;
    real kappa;
    real muM;
    real R0;
    real I0;
    real ds[x_i[1]];

    /*########## (declare) fitted  parameters ##########*/
    real muR_dash;
    real muR_dash2;
    real rho;
    real psi_N1;
    real psi_N2;
    real beta;
    
    real sd_RBC;
    real sd_iRBC;

    real lp_total;

    /*########## (define) derived  parameters ##########*/
    real R_dev;
    real RBC_midn;
    real lambda;
    
    /*########## (declare) data storage  ##########*/
    // One for evaluation 9pm starting
    // The first position is 9h,
    real y_init[x_i[2]]; //                x_i[2] == n_Eq

    // 15h hours delayed with respect to y_init
    // 1st position is midnight following Day 0
    real y_midn[x_i[1],x_i[2]]; //x_i[1] == n_ds, x_i[2] == n_Eq plus 1 is for M

    /*########## (DEFINE) ##########*/
    /*########## (define) fixed  parameters ##########*/
    max_iRBC = x_r[1];
    kappa    = x_r[2];
    muM      = x_r[3];
    R0       = x_r[4];
    I0       = x_r[5];
    
    /*########## (define) estimated  parameters ##########*/
    sd_RBC  = phi[1];
    sd_iRBC = phi[2];
    
    muR_dash  = theta[1];
    muR_dash2 = theta[2];
    rho       = theta[3];
    psi_N1    = theta[4];
    psi_N2    = theta[5];
    beta      = theta[6];
            
    /*########## (define) initial conditions ##########*/
    y_init[1] = 0;      //N1
    y_init[2] = 0;      //N2
    y_init[3] = R0;     //R
    y_init[4] = I0;     //I
    y_init[5] = 0;      //M

    //Wind the clock forward by 15 hours, 0.625 day (from 9h to 12h)
    y_midn[1,1] = 0.625 * psi_N1*(y_init[4]/max_iRBC);
    y_midn[1,2] = 0.625 * psi_N2*(y_init[4]/max_iRBC)+y_init[2];

    /*########## Model phase: RBC turnover (instantaneous) ##########*/
    R_dev = R0 - sum(y_init[3:4]);
    if(R_dev<0) {R_dev =0;}

    y_midn[1,3] = y_init[3]*exp(-(muR_dash+y_midn[1,1])) + R0*(1-exp(-muR_dash2)) + rho*R_dev;
    y_midn[1,4] = y_init[4]*exp(-(muR_dash+y_midn[1,1]+y_midn[1,2]));

    /*########## Model phase: iRBC bursting ##########*/
    y_midn[1,5] = beta*y_midn[1,4];
    
    /*########## Model phase: Parasite invasion ##########*/
    lambda = y_midn[1,5]/(y_midn[1,3]+(muM/kappa));
    
    y_midn[1,3] = y_midn[1,3]*exp(-lambda);
    y_midn[1,4] = lambda*y_midn[1,3];
    
    /*########## (MODEL) ##########*/
    for (d in 1:(x_i[1]-1)){
        /*########## Model phase: Host response regulation ##########*/
        y_midn[d+1,1] = psi_N1*(y_midn[d,4]/max_iRBC);
        y_midn[d+1,2] = psi_N2*(y_midn[d,4]/max_iRBC)+y_midn[d,2];
        
        /*########## Model phase: RBC turnover (instantaneous) ##########*/
        if((d-2)<1){
            R_dev = R0 - sum(y_init[3:4]);
        } else{
            R_dev = R0 - sum(y_midn[(d-2),3:4]);
        }
        if(R_dev<0) {R_dev =0;}
        
        y_midn[d+1,3] = y_midn[d,3]*exp(-(muR_dash+y_midn[d+1,1])) + R0*(1-exp(-muR_dash2)) + rho*R_dev;
        y_midn[d+1,4] = y_midn[d,4]*exp(-(muR_dash+y_midn[d+1,1]+y_midn[d+1,2]));
                    
        /*########## Model phase: iRBC bursting ##########*/
        y_midn[d+1,5] = beta*y_midn[d+1,4];
        
        /*########## Model phase: Parasite invasion ##########*/
        lambda = y_midn[d+1,5]/(y_midn[d+1,3]+(muM/kappa));
        
        y_midn[d+1,3] = y_midn[d+1,3]*exp(-lambda);
        y_midn[d+1,4] = lambda*y_midn[d+1,3];

    }
    
    return y_midn;

    }
}
