library("rstan")
load("output1.rda")
extracted_output=rstan::extract(output1)
source("model_input.R")

######## Simulate from the posterior mean ########
expose_stan_functions("plot_simulate.stan")

post_mean1_fixed = post_sd1_fixed = rep(NA,n_RndEffs)

post_mean1_fixed[1] = mean(extracted_output$muR_dash)
post_mean1_fixed[2] = mean(extracted_output$muR_dash2)
post_mean1_fixed[3] = mean(extracted_output$rho)
post_mean1_fixed[4] = mean(extracted_output$psi_N1)
post_mean1_fixed[5] = mean(extracted_output$psi_N2)
post_mean1_fixed[6] = mean(extracted_output$beta)

post_sd1_fixed[1] = sd(extracted_output$muR_dash)
post_sd1_fixed[2] = sd(extracted_output$muR_dash2)
post_sd1_fixed[3] = sd(extracted_output$rho)
post_sd1_fixed[4] = sd(extracted_output$psi_N1)
post_sd1_fixed[5] = sd(extracted_output$psi_N2)
post_sd1_fixed[6] = sd(extracted_output$beta)

post_mean1_theta = post_sd1_theta = matrix(NA,nrow=n_RndEffs,ncol=n_mice)
for(m in 1:n_mice){
  post_mean1_theta[,m] = apply(extracted_output$theta[,m,],2,mean)
  post_sd1_theta[,m] = apply(extracted_output$theta[,m,],2,sd)
}

post_mean1_sd_s = apply(extracted_output$sd_s,2,mean) 
post_sd1_sd_s = apply(extracted_output$sd_s,2,sd)  
post_mean1_sd_u = apply(extracted_output$sd_u,2,mean)
post_sd1_sd_u = apply(extracted_output$sd_u,2,sd) 

post_mean1_mean_phi = apply(extracted_output$phi,2,mean)
post_mean1_sd_phi = apply(extracted_output$phi,2,sd)

rbc_post_mean=irbc_post_mean=array(NA,dim=c(n_mice,n_ds))

for(m in 1:n_mice){
  phi = post_mean1_mean_phi
  x_i = c(n_ds=n_ds,
          n_Eq=n_Eq)
  x_r = c(max_iRBC = max_iRBC,
          kappa = kappa,
          muM = muM,
          R0 = R0[m],
          I0 = I0[m])
  theta = post_mean1_theta[,m]
  predictedFit=malaria_fit(phi,theta, x_r, x_i) #indexed as predictedFit[[time]][variable]
  
  for(t in 1:14){
    rbc_post_mean[m,t] = rnorm(1,sum(predictedFit[[t]][3:4]),phi[1]) #R[t] with noise
    irbc_post_mean[m,t] = 10^rnorm(1,log10(predictedFit[[t]][4]+1),phi[2]) #I[t]
  }
}

rbc_post_mean = round(unname(unlist(as.data.frame(t(rbc_post_mean)))))
irbc_post_mean = round(unname(unlist(as.data.frame(t(irbc_post_mean)))))

rbc_post_mean[y_RBC==0] = 0
irbc_post_mean[y_iRBC==0] = 0

model_input_post_mean = list(n_RndEffs = n_RndEffs,
                             n_Eq = n_Eq,
                             n_obs = n_obs,
                             n_mice = n_mice,
                             n_strains = n_strains,
                             strain_id = strain_id,
                             strain = strain,
                             mouse = mouse,
                             day = day,
                             y_RBC = rbc_post_mean,
                             y_iRBC = irbc_post_mean,
                             n_ds = n_ds,
                             max_iRBC = max_iRBC,
                             kappa = kappa,
                             muM = muM,
                             R0 = R0,
                             I0 = I0)

save(file="post_mean1_fixed.rda",post_mean1_fixed)
save(file="post_sd1_fixed.rda",post_sd1_fixed)

save(file="post_mean1_theta.rda",post_mean1_theta)
save(file="post_sd1_theta.rda",post_sd1_theta)

save(file="post_mean1_sd_s.rda",post_mean1_sd_s)
save(file="post_sd1_sd_s.rda",post_sd1_sd_s)
save(file="post_mean1_sd_u.rda",post_mean1_sd_u)
save(file="post_sd1_sd_u.rda",post_sd1_sd_u)

save(file="post_mean1_mean_phi.rda",post_mean1_mean_phi)
save(file="post_mean1_sd_phi.rda",post_mean1_sd_phi)

save(file="model_input_post_mean.rda",model_input_post_mean)

