#########################################################
library(knitr)
.cran_packages <- c("dplyr", "tidyverse", "lsmeans")
.inst <- .cran_packages %in% installed.packages()
if(any(!.inst)) {
	install.packages(.cran_packages[!.inst])
}
sapply(.cran_packages, require, character.only = TRUE)
#########################################################

load("figure1.rda")
sink("analysis_output.txt")
set.seed(12345)
Contrasts <- list(
	'LXN vs HFD' = c(-1, 1, 0, 0, 0),
	'HXN vs HFD' = c(-1, 0, 1, 0, 0),
	'TXN vs HFD' = c(-1, 0, 0, 1, 0),
	'LFD vs HFD' = c(-1, 0, 0, 0, 1),
	'TXN vs LFD' = c(0, 0, 0, 1, -1))

names <- colnames(dexa)
print(names)

cat("\n===================================================================================\n")
cat("Some summary statistics and Contrast comparison between HFD and other treatments:\n")
cat("===================================================================================\n")


weight <- total_gained %>% 
	group_by(vars) %>% 
	summarise(mean_wt_g_pct = sprintf("%0.2f", mean(Weight_gain_percent)), 
			  median_wt_g_pct = sprintf("%0.2f", median(Weight_gain_percent)),
			  se_wt_g_pct = sprintf("%0.2f", sd(Weight_gain_percent)/sqrt(n())),
			  mean_wt = sprintf("%0.2f",mean(Weight)), 
			  median_wt = sprintf("%0.2f",median(Weight)),
			  se_wt = sprintf("%0.2f", sd(Weight)/sqrt(n()))) 
cat("\n9.weight:\n")
print(weight)
model_wg <- lm(Weight_gain_percent ~ vars, data = total_gained)
leastsquare_wg <- lsmeans(model_wg, "vars")
output_wg <- contrast(leastsquare_wg, Contrasts, adjust = "none")
cat("\n9.Differences in % weight gained:\n")
print(output_wg)

food <- total_food %>% 
	group_by(vars) %>% 
	summarise(mean = mean(total), 
			  median = median(total),
	          se = sd(total)/sqrt(n()))
cat("\n10.food intake:\n")
print(food)
model_fd <- lm(total ~ vars, data = total_food)
leastsquare_fd <- lsmeans(model_fd, "vars")
output_fd <- contrast(leastsquare_fd, Contrasts, adjust = "none")
cat("\n10.Differences in total food consumed:\n")
print(output_fd)

calories <- total_cal %>% 
	group_by(vars) %>% 
	summarise(mean = mean(total), 
			  median = median(total),
			  se = sd(total)/sqrt(n()))
cat("\n11.calorie intake:\n")
print(calories)
model_cal <- lm(total ~ vars, data = total_cal)
leastsquare_cal <- lsmeans(model_cal, "vars")
output_cal <- contrast(leastsquare_cal, Contrasts, adjust = "none")
cat("\n11.Differences in total calories consumed:\n")
print(output_cal)


sink()