function olfactory_stimuli

%create values
%preparation
prepair=[0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0]';
prepodor1=[1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0]';
prepodor2=[0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0]';
prepodor3=[0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0]';
preparation=[prepair prepodor1 prepodor2 prepodor3];
%presentation
presair=[0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0]';
presodor1=[1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0]';
presodor2=[0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0]';
presodor3=[0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0]';
presentation=[presair presodor1 presodor2 presodor3];
%termination
termination=[0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0]';

%create digital I/O object and add lines to the object
dio=digitalio('nidaq','Dev1');
addline(dio,0:23,'out');

%annotate working lines
dio.Line(1).LineName='Odor 1 Influx';
dio.Line(2).LineName='Odor 2 Influx';
dio.Line(3).LineName='M1 Air Efflux';
dio.Line(4).LineName='Odor 1 Efflux';
dio.Line(5).LineName='Odor 2 Efflux';
dio.Line(6).LineName='Shuttle Valve';
dio.Line(7).LineName='Shock';
dio.Line(9).LineName='Odor 3 Influx';
dio.Line(10).LineName='Odor 3 Efflux';
dio.Line(17).LineName='2P trigger1';
dio.Line(18).LineName='2P trigger2';
dio.Line(19).LineName='2P trigger3';
dio.Line(20).LineName='2P trigger4';

%initiation
putvalue(dio,termination);

%get odorID
odorID=input('Please select the odor presenting to fly, 1=air, 2=odor1, 3=odor2, 4=odor3...');

%get odorTime
odorTime=input('Please input the delivery protocol in the format of [preOdor odorDuration postOdor]...');

fprintf('Please press a random key followed by enter key when you get prepared/n');
pause;

%carry out odor protocols
putvalue(dio,preparation(:,odorID));
pause(odorTime(1));
putvalue(dio,presentation(:,odorID));
pause(odorTime(2));
putvalue(dio,preparation(:,odorID));
pause(odorTime(3));
putvalue(dio,termination);

%delete device object
delete(dio);
clear all

end