# analysis of RIC_perceptual data

library(readxl)
library(ez)

rm(list=ls())

setwd("E:/Dropbox/postdocData/RIC_perceptual/Data/")

d <-read_excel("data_RICperceptual_forR.xlsx", sheet = 1, col_names = FALSE)
colnames(d)[1]<-"subID"
colnames(d)[2]<-"group"
colnames(d)[3]<-"condition"
colnames(d)[4]<-"interval"
colnames(d)[5]<-"valid"
colnames(d)[6]<-"dp"

d$subID=factor(d$subID)
d$group=factor(d$group)
d$condition=factor(d$condition)
d$interval=factor(d$interval)
d$valid=factor(d$valid)


# omnibus anova
dp_anova=ezANOVA(data = d, dv = .(dp), wid = .(subID), within = .(condition, interval, valid), between = .(group))
dp_anova[1]$ANOVA$F <- round(dp_anova[1]$ANOVA$F, digits = 3)
dp_anova[1]$ANOVA$p <- round(dp_anova[1]$ANOVA$p, digits = 5)
dp_anova[1]$ANOVA$ges <- round(dp_anova[1]$ANOVA$ges, digits = 3)
print(dp_anova)

# short targets only
dS<-subset(d,interval == 1)
dp_anova=ezANOVA(data = dS, dv = .(dp), wid = .(subID), within = .(condition, valid), between = .(group))
dp_anova[1]$ANOVA$F <- round(dp_anova[1]$ANOVA$F, digits = 3)
dp_anova[1]$ANOVA$p <- round(dp_anova[1]$ANOVA$p, digits = 5)
dp_anova[1]$ANOVA$ges <- round(dp_anova[1]$ANOVA$ges, digits = 3)
print(dp_anova)

# interval
dSi<-subset(dS,condition == 2)
dp_anova=ezANOVA(data = dSi, dv = .(dp), wid = .(subID), within = .(valid), between = .(group))
dp_anova[1]$ANOVA$F <- round(dp_anova[1]$ANOVA$F, digits = 3)
dp_anova[1]$ANOVA$p <- round(dp_anova[1]$ANOVA$p, digits = 5)
dp_anova[1]$ANOVA$ges <- round(dp_anova[1]$ANOVA$ges, digits = 3)
print(dp_anova)

# rhythm
dSr<-subset(dS,condition == 1)
dp_anova=ezANOVA(data = dSr, dv = .(dp), wid = .(subID), within = .(valid), between = .(group))
dp_anova[1]$ANOVA$F <- round(dp_anova[1]$ANOVA$F, digits = 3)
dp_anova[1]$ANOVA$p <- round(dp_anova[1]$ANOVA$p, digits = 5)
dp_anova[1]$ANOVA$ges <- round(dp_anova[1]$ANOVA$ges, digits = 3)
print(dp_anova)

# compare tasks in controls
dSc<-subset(dS,group == 0)
dp_anova=ezANOVA(data = dSc, dv = .(dp), wid = .(subID), within = .(condition, valid))
dp_anova[1]$ANOVA$F <- round(dp_anova[1]$ANOVA$F, digits = 3)
dp_anova[1]$ANOVA$p <- round(dp_anova[1]$ANOVA$p, digits = 5)
dp_anova[1]$ANOVA$ges <- round(dp_anova[1]$ANOVA$ges, digits = 3)
print(dp_anova)

