% allows user to find polarization of a cell on a surface as Fluorescence
% intensity ratio (FIR) over time 
% outputs a number sequence representing the FIR over time

% uses X-Y_Z_t (3D videos) image to determine the location of the cell and
% to find the ratio between the fluorescence of the bottom and the top of the cell  

% image has to be cropped to individual cell before analysis

% FM= Fluorescence channel1
% Lys= Fluorescence channel2
% tpoints= total number of frames
% zslices= total number of Z slices

    
% first find the bottom and top of the cell using FM membrane stain (and manually check if this is accurate)
Fmim= FM;
clear mhcls
clear mhcl2
for i= 1:tpoints;
for j= 1:zslices;
    mim= Fmim(:,:,j,i);
    mimm= mim{1};
    hcl(j)= (mean(mimm(:)));
end
hcls(i,:)= hcl;
mhcl= mean(hcls);
end
lowave= min(mhcl);
setave= mhcl-lowave;
firstave= setave(1);
ave2= firstave/6;
ave3= ave2+lowave;
mhcl(mhcl<ave3)= NaN;
cutof= sum(~isnan(mhcl));
meassli= floor(cutof/2);
measslis(k)= meassli; %DOUBLE CHECK TO MAKE SURE THESE ARE ACCURATE!!!!
end

LYSim= LYS;
%find distribution of Lysosomes
for i= 1:tpoints;
    clear Fullist
    clear finlist
    clear adj_dist
    clear adj1time
    sim= LYSim(:,:,2,i);
    ssim= sim;
    pixl= size(ssim(:)); %finds total # of pixels 
    for j= 1:cutof;
        mim= LYSim(:,:,j,i);
        mmim= mim{1};
        list1= mmim(:);
        Fullist(j,:)= list1;    
    end 
    % remove background fluorescence (fluorescence outside of cell boundary)
    % manually set percentage for background cutoff
       finlist= (Fullist(:));
       pixl= size(finlist);
       thpixl2= cell(pixl(1)/10);  %set threshold percentage for FIR!
       sortlist= sort(finlist,'descend');
       Thresh2= sortlist(thpixl2);
    for  j= 1:cutof;
         jim= LYSim(:,:,j,i);
         jimz= jim{1};
         jimed= jimz; 
         jimed(jimed<Thresh2)= nan;
         jadj1= sum((jimed(:)));
         jadj1time(j)= jadj1;
    end
        % find total adj. fluorescence per timepoint
        sum_jadj1time= sum(jadj1time);
        % find total fluorescence for each Z slice
    for j= 1:cutof; 
        jdistl=  jadj1time(j)/sum_jadj1time;
        jadj_dist(j)= jdistl;    
    end
    % divide cells into bottom and top based on total number of Z slices
    if cutof== 4;
       bottom4= (jadj_dist(1)+jadj_dist(2));
       top4= (jadj_dist(4)+jadj_dist(3));
    elseif cutof== 5;
       bottom4= (jadj_dist(1)+jadj_dist(2));
       top4= (jadj_dist(5)+jadj_dist(4)+jadj_dist(3));
    elseif cutof== 6;
       bottom4= (jadj_dist(1)+jadj_dist(2)+jadj_dist(3));
       top4= (jadj_dist(6)+jadj_dist(5)+jadj_dist(4));
    elseif cutof == 7;
       bottom4= (jadj_dist(1)++jadj_dist(2)+jadj_dist(3));
       top4= (jadj_dist(7)+jadj_dist(6)+jadj_dist(5)+jadj_dist(4));
    elseif cutof== 8;
       bottom4= (jadj_dist(1)+jadj_dist(2)+jadj_dist(3)+jadj_dist(4));
       top4= (jadj_dist(8)+jadj_dist(7)+jadj_dist(6)+jadj_dist(5));
    elseif cutof== 9;
       bottom4= (jadj_dist(1)+jadj_dist(2)+jadj_dist(3)+jadj_dist(4));
       top4= (jadj_dist(9)+jadj_dist(8)+jadj_dist(7)+jadj_dist(6)+jadj_dist(5));
    elseif cutof== 10;
       bottom4= (jadj_dist(1)+jadj_dist(2)+jadj_dist(3)+jadj_dist(4)+jadj_dist(5));
       top4= (jadj_dist(10)+jadj_dist(9)+jadj_dist(8)+jadj_dist(7)+jadj_dist(6));
    end
    % find ratio of bottom fluorescence over top fluorescence
    LYS_Fir= bottom4/top4;
    LYS_Firs(i)= LYS_Fir;
end
