% allows user to find the fluorescence intensity of  channel 1 for individual cells, and
% find the fluorescent intensity of channel 2 above the bilayer
% to find the FM fluorescence of a cell, as well as the intracellular Ag fluorescence of
% the same cell 
% find Ag fluorescence as any pixels at least 3x brighter than the MFI

% intracellular is measured after removing any fluorescence from the PLB. 

% outputs a variety of data concerning fluorescent intensity of each channel


% manually draw area of individual cells

% proj_rd2= red image(Z-Merged)  
% proj_gr2= green image(Z-Merged)
leng= length(proj_rd2(:,1));
widt= length(proj_rd2(1,:));
mskt= zeros(leng,widt);

count= 0;
x= 0;
while x== 0;
count= count+1;


imshow(imadjust(proj_rd2));
h= imellipse();
msk= createMask(h);
mskk= msk*count;
mskt= mskt+mskk;

prompt= 'are you done? (1=yes  0=no) ';
x= input(prompt);
end


% measure FM and Ag intensity

DATA2= []; %
DATA12= []; %
DATA32= []; %

for k= numimm
    clear mask2
    clear DATA
    clear DATA1
    clear DATA3
    clear mean_rd
    clear mean_rd2
    clear mean_gr
    clear mean_gr2
    clear max_rd
    clear max_rd2
    clear max_gr
    clear max_gr2
    clear tot_rd
    clear tot_rd2
    clear tot_gr
    clear tot_gr2
    clear topp_rd
    clear topp_rd2
    clear topp_gr
    clear topp_gr2
    clear nump_gr
    clear nump2_gr
    clear percp_gr
    clear percp2_gr
    
   mask= mskt;
   numobjs(k)= max(mask(:));
    
   % proj_gr_tots= Z-merged green channel
   % proj_gr_tots2= Z-merged green channel, excluding bilayer
   % proj_rd_tots= Z-merged red channel
   % proj_rd_tots2= Z-merged red channel, excluding bilayer
   
   %first isolate individual cells 
   for i= 1:numobjs(k)
       
       greenn= proj_gr_tots;
       greenn2= proj_gr_tots2;
       redd= proj_rd_tots;
       redd2= proj_rd_tots2;
      
       mask2= mask;
       mask2(mask2~=i)= nan;
       mask2(mask2>1)= 1;
       
       grr= greenn.*mask2;
       grr2= greenn2.*mask2;
       rdd= redd.*mask2;
       rdd2= redd2.*mask2;
       
       % measure intensity of individual cell in each channel
      
       
       settop= 50; %set top %
       % remove background
       gr_list= sort(grr(:),'descend');
       gr_list= gr_list(~isnan(gr_list));
       toppg= ceil(length(gr_list)/settop); 
       gr_slist= gr_list(1:toppg);
       
       % calculate % of pixels that are positive for intracellular Ag (more
       % than 3x as bright as MFI)
       grmean= mean(gr_list);
       gr_hi= gr_list(gr_list>=(gr mean*3));
       gr_hipix= length(gr_hi); 
       gr_perhipix= ((gr_hipix/(length(gr_list)))*100); 
       
       % remove background
       gr2_list= sort(grr2(:),'descend');
       gr2_list= gr2_list(~isnan(gr2_list));
       topp2= cell(length(gr2_list)/settop); %set top %
       gr2_slist=gr2_list(1:topp2);
       % calculate % of pixels that are positive for intracellular Ag more
       % than 3x as bright as MFI)
       gr2mean= mean(gr2_list);
       gr2_hi= gr2_list(gr2_list>=(gr2mean*3));
       gr2_hipix=length(gr2_hi);
       gr2_perhipix= ((gr2_hipix/(length(gr2_list)))*100);

       
       rd_list= sort(rdd(:),'descend');
       rd_list= rd_list(~isnan(rd_list));
       toppr= cell(length(rd_list)/settop); %set top %
       rd_slist= rd_list(1:toppr);
       
       rd2_list= sort(rdd2(:),'descend');
       rd2_list= rd2_list(~isnan(rd2_list));
       toppr2= ceil(length(rd2_list)/settop); %set top %
       rd2_slist= rd2_list(1:toppr);
       
       % find mean fluorescence of all channels
       mean_gr(i,1)= nanmean(grr(:));
       mean_gr2(i,1)= nanmean(grr2(:));
       mean_rd(i,1)= nanmean(rdd(:));
       mean_rd2(i,1)= nanmean(rdd2(:));
       % find Total fluorescence of all channels
       tot_gr(i,1)= nansum(grr(:));
       tot_gr2(i,1)= nansum(grr2(:));
       tot_rd(i,1)= nansum(rdd(:));
       tot_rd2(i,1)= nansum(rdd2(:));
       % find maximum fluorescence of all channels
       max_gr(i,1)= nanmax(grr(:));
       max_gr2(i,1)= nanmax(grr2(:));
       max_rd(i,1)= nanmax(rdd(:));
       max_rd2(i,1)= nanmax(rdd2(:));
       %find mean fluorescence of all channels, minus the background
       topp_gr(i,1)= mean(gr_slist);
       topp_gr2(i,1)= mean(gr2_slist);
       topp_rd(i,1)= mean(rd_slist);
       topp_rd2(i,1)= mean(rd2_slist);
       
       % total number of intracellular Ag pixels per cell
       nump_gr(i,1)= gr_hipix;
       nump2_gr(i,1)= gr2_hipix;
       %Percentage of number of intracellular Ag pixels per cell
       percp_gr(i,1)= gr_perhipix;
       percp2_gr(i,1)= gr2_perhipix;

      
   end
       DATA(:,1)= mean_rd;
       DATA(:,2)= mean_gr;
       DATA(:,3)= tot_rd;
       DATA(:,4)= tot_gr;
       DATA(:,5)= max_rd;
       DATA(:,6)= max_gr;
       DATA(:,7)= topp_rd;
       DATA(:,8)= topp_gr;
       
       
       DATA1(:,1)= mean_rd2;
       DATA1(:,2)= mean_gr2;
       DATA1(:,3)= tot_rd2;
       DATA1(:,4)= nump2_gr;
       DATA1(:,5)= max_rd2;
       DATA1(:,6)= max_gr2;
       DATA1(:,7)= topp_rd2;
       DATA1(:,8)= topp_gr2;
       
       DATA3(:,1)= mean_rd2;
       DATA3(:,2)= topp_gr2;
       DATA3(:,3)= nump2_gr;
       DATA3(:,4)= percp2_gr;
       
       
   DATA2= [DATA2;DATA];
   DATA12= [DATA12;DATA1];
   DATA32= [DATA32;DATA3];
end



