%% Load empirical data

% cd('') 
clc; clear;
n_subjects = 47;

% Load group-level data
load('groupSC')
load('TM_Groups');

% Subject-level correlations
R_dk = zeros(n_subjects,3);
R_aal = zeros(n_subjects,3);
load('Rs');

% Emphasis in panels B and C are on z=3
r_group_aal = r_group_aal_3d0;
r_group_dk = r_group_dk_3d0;

% Panel A matrices to be plotted
R = [R_aal nan(n_subjects, 1) R_dk];
R_group = [r_group_aal_2d5, r_group_aal_3d0, r_group_aal_3d5, nan, r_group_dk_2d5, r_group_dk_3d0 r_group_dk_3d5];

% Null correlations 
load('p_r_randpermSIMMETR_AALz3.mat'); r_group_null_aal = r_rand_corr; 
load('p_r_randpermSIMMETR_DKTz3.mat'); r_group_null_dk = r_rand_corr; 

% Non-parametric p-values
npp_group_aal = sum(r_group_null_aal >= r_group_aal)./length(r_group_null_aal);
npp_group_dk = sum(r_group_null_dk >= r_group_dk)./length(r_group_null_dk);

% Parameters
n_z_thr = 3;

%% Plot - Group-level AAL and DK

fig_rows = 3;
fig_cols = 11;

fs = 14;

scatter_density_parameter = 40;
scatter_marker_size = 40;

customize_opt.median_color = 'k';
customize_opt.whisker_color = 'k';
customize_opt.box_color = 'k';
customize_opt.median_lw = 1;
customize_opt.box_lw = 1;
customize_opt.whisker_lw = 1;

colormap_z_thr = othercolor('Accent3', n_z_thr);

scatter_all_opt.jitter = 0.15;
scatter_all_opt.group_color = [colormap_z_thr; [0 0 0]; colormap_z_thr];
scatter_all_opt.marker = '.';
scatter_all_opt.marker_size = 200;

%%% Make figure

fig = figure;
fig.WindowStyle = 'normal';
fig.Position = [-268 1080 1707 566]; 
fig.PaperOrientation = 'landscape';
fig.PaperType = 'A3';

%%% Panel 1: Subject-level SC-TM correlations

panel{1} = subplot(fig_rows, fig_cols, [1,12]);

for i = 1:n_z_thr
    plot(nan, nan, 'Color', colormap_z_thr(i,:), 'LineWidth', 5); hold on
end

scatter(1:length(R_group), R_group, 50, 'k', 'd', 'filled'); hold on;
ylabel('Subject-level SC-TM correlations');
boxplot_v2(R, scatter_all_opt, [], customize_opt, [], []);
% panel{1}.Title.String = sprintf('Subject-level\nSC-TM correlations');

panel{1}.XLim = [0, 8];
panel{1}.XTick = [2,6];
panel{1}.XTickLabel = {'AAL atlas', 'DK atlas'};

panel{1}.YLim = [-0.05 0.42];

leg = legend({'2.5 ', '3', '3.5'}, 'Location', 'southoutside', 'Orientation', 'horizontal');
title(leg, 'Z threshold');


%%% Panel 2: Group SC

panel{2} = subplot(fig_rows, fig_cols, 3);
imagesc(log10(SC_group_aal));
panel{2}.Title.String = 'Group SC (AAL)';
axis square;

%%% Panel 3: Group TM

panel{3} = subplot(fig_rows, fig_cols, 14);
imagesc(TM_group_aal);
panel{3}.Title.String = 'Group TM';
axis square;

%%% Panel 4: Group SC-TM scatter plot
idx = find(triu(~~SC_group_aal.*ones(length(SC_group_aal)),1));

panel{4} = subplot(fig_rows, fig_cols, [4,5,15,16]);

u = inormal(SC_group_aal(idx));
v = inormal(TM_group_aal(idx));
x = inormal(triue(SC_group_aal));
y = inormal(triue(TM_group_aal));

% scatter(x,y, scatter_marker_size, heatscatter(x,y,scatter_density_parameter), '.');
scatter(u,v, 80, [0,80,150]./255, '.');

[rho,p] = corr(x,y, 'Type', 'Spearman');
xlabel('Structural connectivity');
ylabel('Transition probability');
lsl = lsline; lsl.LineWidth = 2; lsl.Color = 'k';
panel{4}.Title.String = sprintf('r = %.3f, p = %.0e', rho, p);

%%% Panel 5: Group AAL SC-TM null distribution

panel{5} = subplot(fig_rows, fig_cols, [6,17]);
rc = raincloud_plot(r_group_null_aal, 'color', [0.6 0.65 0.8], 'line_width', 1, 'box_on', 1, 'alpha', 1);
rc{2}.SizeData = 5;
l = line([r_group_aal r_group_aal], panel{5}.YLim, 'LineStyle', '-.', 'LineWidth', 2);
panel{5}.Title.String = sprintf('Null r distribution\n(p = %.4f)', npp_group_aal);
% panel{5}.Title.String = sprintf('Null r distribution\n(p < 0.001)');
panel{5}.View = [90 -90];

%%% Panel 6: DK SC

panel{6} = subplot(fig_rows, fig_cols, 8);
imagesc(log10(SC_group_dk));
panel{6}.Title.String = 'Group SC (DK)';
axis square;

%%% Panel 7: DK TM

panel{7} = subplot(fig_rows, fig_cols, 19);
imagesc(TM_group_dk);
panel{7}.Title.String = 'Group TM';
axis square;

%%% Panel 8: DK SC-TM scatter plot

idx = find(triu(~~SC_group_dk.*ones(length(SC_group_dk)),1));

panel{8} = subplot(fig_rows, fig_cols, [9,10,20,21]);

u = inormal(SC_group_dk(idx));
v = inormal(TM_group_dk(idx));
x = inormal(triue(SC_group_dk));
y = inormal(triue(TM_group_dk));
scatter(u,v, 80, [0,80,150]./255, '.');

% scatter(x,y, scatter_marker_size, heatscatter(x,y,scatter_density_parameter), '.');
[rho,p] = corr(x,y, 'Type', 'Spearman');
xlabel('Structural connectivity');
ylabel('Transition probability');
lsl = lsline; lsl.LineWidth = 2; lsl.Color = 'k';
panel{8}.Title.String = sprintf('r = %.3f, p = %.0e', rho, p);

%%% Panel 9: Group DK SC-TM null distribution
panel{9} = subplot(fig_rows, fig_cols, [11,22]);
rc = raincloud_plot(r_group_null_dk, 'color', [0.6 0.65 0.8], 'line_width', 1, 'box_on', 1, 'alpha', 1);
rc{2}.SizeData = 5;
l = line([r_group_dk r_group_dk], panel{9}.YLim, 'LineStyle', '-.', 'LineWidth', 2);
panel{9}.Title.String = sprintf('Null r distribution\n(p = %.4f)', npp_group_dk);
% panel{9}.Title.String = sprintf('Null r distribution\n(p < 0.001)');
panel{9}.View = [90 -90];

%%% Position adjustments

% [left bottom width height]

% for i = 1:9
for i = 1:9
    panel{i}.FontSize = 14;
    panel{i}.Title.FontWeight = 'normal';
end

% Panel 1
panel{1}.Position(1) = 0.075; % left
panel{1}.Position(2) = 0.35; % bottom
panel{1}.Position(3) = 0.15; % width
panel{1}.Position(4) = 0.415; % height

% Panel 2
panel{2}.OuterPosition(1) = 0.275; % left
panel{2}.OuterPosition(2) = 0.565; % bottom
panel{2}.OuterPosition(3) = 0.072;

% Panel 3
panel{3}.OuterPosition(1) = 0.275; % left
panel{3}.OuterPosition(2) = panel{1}.OuterPosition(2); % bottom

% Panel 4
panel{4}.Position(1) = 0.385; % left
panel{4}.Position(2) = panel{1}.Position(2); % bottom
panel{4}.Position(4) = panel{1}.Position(4); % height

% Panel 5
panel{5}.Position(1) = 0.54; % left
panel{5}.Position(2) = panel{1}.Position(2); % bottom
panel{5}.OuterPosition(3) = panel{2}.OuterPosition(3); % width
panel{5}.Position(4) = panel{1}.Position(4); % height

left_offset_1 = panel{3}.OuterPosition(1) - (panel{1}.OuterPosition(1) + panel{1}.OuterPosition(3));

left_offset_2 = left_offset_1 + panel{4}.OuterPosition(1) - (panel{3}.OuterPosition(1) + panel{3}.OuterPosition(3));

left_offset_3 = left_offset_2 + panel{5}.OuterPosition(1) - (panel{4}.OuterPosition(1) + panel{4}.OuterPosition(3));

% Panel 6
panel{6}.OuterPosition(1) = panel{6}.OuterPosition(1) + left_offset_1; % left
panel{6}.OuterPosition(2) = 0.565; % bottom

% Panel 7
panel{7}.OuterPosition(1) = panel{7}.OuterPosition(1) + left_offset_1; % left
panel{7}.OuterPosition(2) = panel{1}.OuterPosition(2); % bottom

% Panel 8
panel{8}.OuterPosition(1) = panel{8}.OuterPosition(1) + left_offset_2; % left
panel{8}.Position(4) = panel{1}.Position(4); % height
panel{8}.Position(2) = panel{1}.Position(2); % bottom

% Panel 9
panel{9}.OuterPosition(1) = panel{9}.OuterPosition(1) + left_offset_3; % left
panel{9}.Position(2) = panel{1}.Position(2); % bottom
panel{9}.OuterPosition(3) = panel{2}.OuterPosition(3); % width
panel{9}.Position(4) = panel{1}.Position(4); % height

%%% Panel letters
 title_vec = {'A', 'B', 'C'};
 aux = [1 2 6];
 height_offset = 0.11;
for i = 1:length(aux)
    idx = aux(i);
    title_aux = annotation('textbox', 'String', title_vec{i}, 'FontSize', 26);
    title_aux.Position = [panel{idx}.Position(1), panel{idx}.Position(2) + panel{idx}.Position(4) + height_offset, 0, 0];
end
clear title_aux aux;

