# analysis of Corona and medications, Ariel Israel, August 2020

Sys.setenv('JAVA_HOME'='C:/Program Files/Java/jre1.8.0_261')

library(survival)
library(tableone)
library(magrittr)
library(stargazer)
library(dplyr)
library(ggplot2)
library(weights)
library(ggrepel)
library(jpeg)
library(grid)
library(gridExtra)
library(xlsx)

setwd("D:/datasets/backup/Projects/ariel/corona_before")
XLS_FILE <- 'comp_hosp_35_to_1_days_before.xlsx'

df_all_1 = read.xlsx(XLS_FILE,'Cohort 1')
df_all_1 = df_all_1[df_all_1$depth==5,]

100.0 * sum((df_all_1$pval<0.05) & (df_all_1$or<1)) / nrow(df_all_1)

df_all_1 = read.xlsx(XLS_FILE,'Cohort 2')
df_all_2 = df_all_2[df_all_2$depth==5,]

100.0 * sum((df_all_2$pval<0.05) & (df_all_2$or<1)) / nrow(df_all_2)

df_all_1$cohort = 'Cohort 1'
df_all_2$cohort = 'Cohort 2'
df_all <- rbind(df_all_1,df_all_2)
df_all$significant <- df_all$pval<0.05
df_all$or[df_all$or>32]=32

x_labeller <- function(x){
	if (x < 1) {
        if (round(x,1) == x) {
            sprintf("%.1f",x)
        } else if (round(x,2) == x) {
            sprintf("%.2f",x)
        } else {
            sprintf("1/%.0f",1/x)
        } 
	} else if (x < 32) {
		sprintf("%.0f",x)
	} else {
		print('Inf.')
	}
}

xbreaks <- c(1/16,1/8,0.25,0.5,0.75,1,2,4,8,16,32)
jpeg(filename='odds_ratio_hist.jpeg',units='in',width=6,height=6,res=300)
ggplot(df_all, aes(or,fill=significant)) + 
  geom_histogram(bins=50) + 
   scale_x_continuous('Odds ratio', trans='log2', breaks=xbreaks, labels=sapply(xbreaks,x_labeller)) + 
   scale_y_continuous('number of products') + 
   scale_fill_manual("significant (p<0.05)",values=c('grey','black')) +
   facet_wrap(~ cohort, ncol = 1) + 
  theme_bw() + geom_vline(xintercept=1) +
  theme(axis.text.x = element_text(size = 8))
dev.off()
