# How to create the figure

In order to plot Figure 3 you have to install and activate the provided conda
environment and run the python script. You do this by using the following
commands:

```
conda env create -f environment.yaml
conda activate gona
python plot_theory_figs.py --yaml=theory_figs.yaml
```

**Note** that plotting Figure 3c requires additional data files `distances.npy`
and `covariances.npy` that we cannot provide as they are several GB large. In order to create these datafiles you need to run:

```
python create_pairwise_covariances_and_eigenvalues.py --yaml=fig3bc.yaml
```

The code for producing all other data files is provided in the repository mentioned in the data availability statement.

# About the data

- `data/eigenvalues.npy` contains the eigenvalues seen in panel B
- `data/distances.npy` and `data/covariances.npy` which are necessary for panel
C are missing (see note above)
- `data/2d2p/cont_theory/` contains the hdf5 files which contain the variances
of covariances seen in panel D and E. All data files are used for panel D,
while only
`D1_K_E100_K_I50_N_x201_N_y201_distrexp_g4_lam_E20_lam_I10_r0.95_seed42.h5`
is used for panel E.
