clear
hold off
hidden off
clf
close all

%-----------------------------------main figure--------------------------------------
size = 7;
width = 0.18;

dy = 0.007;
dy1 = -0.02;
dy2 = -0.01;
dx1 = -0.01;
dx2 = 0.03;

h = 0.02;

C1 = [255 166 0]/255; %green
C2 = [188 80 144]/255; %red
C3 = [0 63 92]/255; %blue


%---------- Figure 6 - figure supplement 1A ----------
%------------ Extracellular K changes ---------------- 
load_model_data_K

dt = 2e-4;
t1 = (1); %signal range
t2 = (6e5);
V = VP(t1:t2); %voltage membrane potential for detection

%------ burst offset detection -------
threshold_off = -20;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_off = find((V > threshold_off) > 0);
%Interspike intervals
ISI_off  = t(Ind_off(2:end))-t(Ind_off(1:end-1));
%Only interspike intervals > 0.1s, otherwise they are within a single burst
minimal_ISI_off = 0.1;
Index_off = find(ISI_off > minimal_ISI_off);

%------ burst onset detection -------
threshold_on = -5;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_on = find((V > threshold_on) > 0);
%Interspike intervals
ISI_on  = t(Ind_on(2:end))-t(Ind_on(1:end-1));
%Only interspike intervals > 0.1s, otherwise they are within a single burst
minimal_ISI_on = 0.1;
Index_on = find(ISI_on > minimal_ISI_on);

Index_range_off = 62:length(Index_off);
Index_range_on = (length(Index_on)-length(Index_range_off)+1):length(Index_on);

%Interburst intervals - distance from  previous burst offset to next burst onset
IBI(1:length(Index_range_on)-1) = t(Ind_on(Index_on(Index_range_on(2:end))))-t(Ind_off(Index_off(Index_range_off(1:end-1))));
IBI(length(Index_range_on)) = t(Ind_on(end))-t(Ind_off(Index_off(Index_range_off(end))));

x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';

%-------------------------plots-------------------------------------
subplot('Position',[0.1300-dx1 0.8483+3*dy-dy1 width 0.0764-h])
plot(t, VP,'k', 'LineWidth', 0.1)
hold on
plot([t(Ind_off(Index_off(Index_range_off))) t(Ind_off(Index_off(Index_range_off)))]+t(t1), [10 15], 'k','LineWidth', 0.05)
plot([0 0]+t(t1)+t(Ind_off(end)), [10 15], 'k','LineWidth', 0.05)% last burst

plot([0 0] + 50, [-70 2], 'b','LineWidth', 0.3)
plot([0 0] + 82, [-70 2], 'b','LineWidth', 0.3)

axis([0 120 -70 15])
set(gca, 'Fontsize', size)
box off
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('V_{PY} (mV)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom') 

text(-35,60, 'A','Fontsize', 9, 'FontWeight', 'Bold');
text(0,40, 'IBI evolution - [K]_o change','Fontsize', 8, 'FontWeight', 'Normal');

subplot('Position',[0.1300-dx1 0.7270+2*dy-dy1-dy2 width 0.0764-h])
plot(t, K_soma,'k', t, K_dend, '-.k')
set(gca, 'Fontsize', size)
box off
ylabel('[K]_o (mM)', 'Fontsize', size)
axis([0 120 3 13])
hold on
%--------legend------
text(60,9.4,'soma', 'Fontsize', size-1)
text(60,6.2,'dend', 'Fontsize', size-1)
plot([0 0] + 50, [3 13], 'b','LineWidth', 0.3)
plot([0 0] + 82, [3 13], 'b','LineWidth', 0.3)
%--------end legend------


subplot('Position',[0.1300-dx1 0.6057+dy-dy1-2*dy2 width 0.0764-h])
plot(t, Na_soma,'k', t, Na_dend,'-.k')
set(gca, 'Fontsize', size)
box off
ylabel('[Na]_i (mM)', 'Fontsize', size)
axis([0 120 9.5 13])

%--------legend------
hold on
text(61,12.5,'soma', 'Fontsize', size-1)
text(61,11.5,'dend', 'Fontsize', size-1)

%--------end legend------

plot([0 0] + 50, [9.5 18], 'b','LineWidth', 0.3)
plot([0 0] + 82, [9.5 18], 'b','LineWidth', 0.3)

subplot('Position',[0.1300-dx1 0.4845-dy1-3*dy2 width 0.0764-h])
plot(t, Cl_soma,'k', t, Cl_dend,'-.k')
set(gca, 'Fontsize', size)
ylabel('[Cl]_i (mM)', 'Fontsize', size)
axis([0 120 4 8])
box off

%--------legend------
hold on
text(60,8.2,'soma', 'Fontsize', size-1)
text(60,7.4,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [4 8], 'b','LineWidth', 0.3)
plot([0 0] + 82, [4 8], 'b','LineWidth', 0.3)

subplot('Position',[0.1300-dx1 0.3632-dy-dy1-4*dy2 width 0.0764-h])
plot(x,y,'k.')
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
grid
set(gca, 'Fontsize', size)
box off
%--------------------Extracellular K changes--------------------
%--------------------Linear function fitting-------------------
hold on
c = polyfit(x,y,1);
y_est = polyval(c,x);
plot(x,y_est,'r','LineWidth',1)
axis([48 83 0 1.5])
text(30.7,0.25, 'linear', 'Fontsize',size+3, 'Color',C3, 'Rotation', 90)

%RMSE
ErrorVector_linear = y_est - y;
sse_linear = sum(ErrorVector_linear .^ 2);
RMS_linear = sqrt(sse_linear/length(x));

text(67,0.25, ['RMSE ' num2str(RMS_linear,3)],'Fontsize',size)

%--------------------Extracellular K changes----------------------
%--------------------Exponential function fitting-----------------

subplot('Position',[0.1300-dx1 0.2419-2*dy-dy1-5*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xe = x;
x = x - min(x);
xval = x;
[xval, yval, est] = curve_fitting_exponential_1_optimized(x,y,xval);
semilogy(x+min(xe), y - est(1) ,'k.');
hold on
plot(xval + min(xe),yval ,'r','LineWidth',1)
grid on 
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s), log','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([48 83 0.1 2])
set(gcf,'color','w');
set(gca, 'Fontsize', size)
box off
text(30.7,0.25, 'exp', 'Fontsize',size+3, 'Color',C3, 'Rotation', 90)

%RMSE
 ErrorVector_exp = yval + est(1) - y;
 sse_exp = sum(ErrorVector_exp.^ 2);
 RMS_exp = sqrt(sse_exp/length(x));

text(67,0.16, ['RMSE ' num2str(RMS_exp,3)],'Fontsize',size)

v = [37 1e-2; 37 4e0; 85 4e0; 85 1e-2];
f = [1 2 3 4];
patch('Faces',f,'Vertices',v,...
    'EdgeColor', C3,'FaceColor','none','LineWidth',0.5, 'LineStyle','--')
set(gca, 'Clipping', 'off')

%--------------------Extracellular K changes------------------------
%--------------------1/sqrt function fitting------------------------

subplot('Position',[0.1300-dx1 0.1206-3*dy-dy1-6*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xval = max(x) - x + 1e0;
plot(xval, y,'k.')
grid
hold on
c = polyfit(1./sqrt(xval),y,1);
y_est = polyval(c,1./sqrt(xval));
plot(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
box off

xlabel('Time until end of SLE (s)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([-1 33 0 1.5])
text(50,0.25, 'sqrt', 'Fontsize',size+3, 'Color',C3, 'Rotation', 90)


%RMSE
ErrorVector_sqrt = y_est - y;
sse_sqrt = sum(ErrorVector_sqrt.^ 2);
RMS_sqrt = sqrt(sse_sqrt/length(x));

text(15,0.25, ['RMSE ' num2str(RMS_sqrt,3)],'Fontsize',size)

%--------------------Extracellular K changes------------------------
%--------------------Logarithmic function fitting-------------------

subplot('Position',[0.1300-dx1 0-4*dy-dy1-7*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';

xval = max(x) - x + 1;
semilogx(xval, y,'k.')
grid
hold on
c = polyfit(log(xval),y,1);
y_est = polyval(c,log(xval));
semilogx(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
box off
xlabel('Time until end of SLE (s), log','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([0.8 40 0 1.5])
text(280,0.25, 'log', 'Fontsize',size+3, 'Color',C3, 'Rotation', 90)

%RMSE
ErrorVector_log = y_est - y;
sse_log = sum(ErrorVector_log.^ 2);
RMS_log = sqrt(sse_log/length(x));

text(4.5,0.28, ['RMSE ' num2str(RMS_log,3)],'Fontsize',size)


%---------- Figure 6 - figure supplement 1B ----------
%------------ Intracellular Na changes ---------------- 
clear
size = 7;
width = 0.18;

dy = 0.007;
dy1 = -0.02;
dy2 = -0.01;
dx2 = 0.02;

h = 0.02;
C1 = [255 166 0]/255; %green
C2 = [188 80 144]/255; %red
C3 = [0 63 92]/255; %blue

load_model_data_Na
dt = 2e-4;
t1 = (1); %signal range
t2 = (6e5);
V = VP(t1:t2); %voltage membrane potential for detection

%------ burst offset-------
threshold_off = -20;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_off = find((V > threshold_off) > 0);
%Interspike intervals
ISI_off  = t(Ind_off(2:end))-t(Ind_off(1:end-1));
%Only interspike intervals > 0.1s, otherwise they are within a single burst
minimal_ISI_off = 0.1;
Index_off = find(ISI_off > minimal_ISI_off);

%------ burst onset-------

threshold_on = -5;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_on = find((V > threshold_on) > 0);
%Interspike intervals
ISI_on  = t(Ind_on(2:end))-t(Ind_on(1:end-1));
%Only interspike intervals > 0.1s, otherwise they are within a single burst
minimal_ISI_on = 0.1;
Index_on = find(ISI_on > minimal_ISI_on);

Index_range_off = 61:length(Index_off);
Index_range_on = (length(Index_on)-length(Index_range_off)+1):length(Index_on);

%Interburst intervals - distance from  previous burst offset to next burst onset
IBI(1:length(Index_range_on)-1) = t(Ind_on(Index_on(Index_range_on(2:end))))-t(Ind_off(Index_off(Index_range_off(1:end-1))));
IBI(length(Index_range_on)) = t(Ind_on(end))-t(Ind_off(Index_off(Index_range_off(end))));
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';

%-------------------------plots-------------------------------------
subplot('Position',[0.4108+dx2 0.8483+3*dy-dy1 width 0.0764-h])
plot(t, VP,'k', 'LineWidth', 0.1)
hold on

plot([t(Ind_off(Index_off(Index_range_off))) t(Ind_off(Index_off(Index_range_off)))]+t(t1), [10 15], 'k','LineWidth', 0.05)
plot([0 0]+t(t1)+t(Ind_off(end)), [10 15], 'k','LineWidth', 0.05)% last burst

plot([0 0] + 50, [-70 2], 'b','LineWidth', 0.3)
plot([0 0] + 61.5, [-70 2], 'b','LineWidth', 0.3)
axis([0 120 -70 15])
set(gca, 'Fontsize', size)
box off
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('V_{PY} (mV)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom') 

text(-35,60, 'B','Fontsize', 9, 'FontWeight', 'Bold');
text(0,40, 'IBI evolution - [Na]_i change','Fontsize', 8, 'FontWeight', 'Normal');

subplot('Position',[0.4108+dx2 0.7270+2*dy-dy1-dy2 width 0.0764-h])
plot(t, K_soma,'k', t, K_dend, '-.k')
set(gca, 'Fontsize', size)
box off
ylabel('[K]_o (mM)', 'Fontsize', size)
axis([0 120 3 13])
hold on
%--------legend------
text(70,10.6,'soma', 'Fontsize', size-1)
text(70,6.6,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [3 13], 'b','LineWidth', 0.3)
plot([0 0] + 61.5, [3 13], 'b','LineWidth', 0.3)

subplot('Position',[0.4108+dx2 0.6057+dy-dy1-2*dy2 width 0.0764-h])
plot(t, Na_soma,'k', t, Na_dend,'-.k')
set(gca, 'Fontsize', size)
box off
ylabel('[Na]_i (mM)', 'Fontsize', size)
axis([0 120 9.5 17])

%--------legend------
hold on
text(70,17,'soma', 'Fontsize', size-1)
text(70,13.8,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [9.5 18], 'b','LineWidth', 0.3)
plot([0 0] + 61.5, [9.5 18], 'b','LineWidth', 0.3)

h11 = subplot(7,3,11);
subplot('Position',[0.4108+dx2 0.4845-dy1-3*dy2 width 0.0764-h])
plot(t, Cl_soma,'k', t, Cl_dend,'-.k')
set(gca, 'Fontsize', size)
ylabel('[Cl]_i (mM)', 'Fontsize', size)
axis([0 120 4 8])
box off

%--------legend------
hold on
text(70,8.2,'soma', 'Fontsize', size-1)
text(70,7.4,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [4 8], 'b','LineWidth', 0.3)
plot([0 0] + 61.5, [4 8], 'b','LineWidth', 0.3)


subplot('Position',[0.4108+dx2 0.3632-dy-dy1-4*dy2 width 0.0764-h])
plot(x,y,'k.')
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
grid
set(gca, 'Fontsize', size)
box off

%--------------------Intracellular Na changes-------------------
%--------------------Linear function fitting-------------------

hold on
c = polyfit(x,y,1);
y_est = polyval(c,x);
plot(x,y_est,'r','LineWidth',1)
axis([48 62 0 0.8])

%RMSE
ErrorVector_linear = y_est - y;
sse_linear = sum(ErrorVector_linear .^ 2);
RMS_linear = sqrt(sse_linear/length(x));

text(55.5,0.12, ['RMSE ' num2str(RMS_linear,3)],'Fontsize',size)

%--------------------Intracelluar Na changes-------------------
%--------------------Exponential function fitting-----------------

subplot('Position',[0.4108+dx2 0.2419-2*dy-dy1-5*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xe = x;
x = x - min(x);
xval = x;
[xval, yval, est] = curve_fitting_exponential_1_optimized(x,y,xval);
semilogy(x+min(xe), y - est(1) ,'k.');
hold on
plot(xval + min(xe),yval ,'r','LineWidth',1)

hold on
grid on 
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s), log','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([48 62 0.005 1])
set(gcf,'color','w');
set(gca, 'Fontsize', size)
box off

%RMSE
 ErrorVector_exp = yval + est(1) - y;
 sse_exp = sum(ErrorVector_exp.^ 2);
 RMS_exp = sqrt(sse_exp/length(x));

text(55.5,0.01, ['RMSE ' num2str(RMS_exp,3)],'Fontsize',size)

%--------------------Intracellular Na changes-------------------
%--------------------1/sqrt function fitting-------------------

subplot('Position',[0.4108+dx2 0.1206-3*dy-dy1-6*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xval = max(x) - x + 1;
plot(xval, y,'k.')
grid
hold on
c = polyfit(1./sqrt(xval),y,1);
y_est = polyval(c,1./sqrt(xval));
plot(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
box off
xlabel('Time until end of SLE (s)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([0 13 0 0.8])

%RMSE
ErrorVector_sqrt = y_est - y;
sse_sqrt = sum(ErrorVector_sqrt.^ 2);
RMS_sqrt = sqrt(sse_sqrt/length(x));

text(6,0.15, ['RMSE ' num2str(RMS_sqrt,3)],'Fontsize',size)

%--------------------Intracellular Na changes-------------------
%--------------------Logarithmic function fitting--------------

subplot('Position',[0.4108+dx2 0-4*dy-dy1-7*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xval = max(x) - x + 1;
semilogx(xval, y,'k.')
grid
hold on
c = polyfit(log(xval),y,1);
y_est = polyval(c,log(xval));
semilogx(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
box off
xlabel('Time until end of SLE (s), log','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([0.6 20 0 0.8])

%RMSE
ErrorVector_log = y_est - y;
sse_log = sum(ErrorVector_log.^ 2);
RMS_log = sqrt(sse_log/length(x));

text(3,0.15, ['RMSE ' num2str(RMS_log,3)],'Fontsize',size)

v = [50 -0.65; 50 1; 0.45 1; 0.45 -0.65];
f = [1 2 3 4];
patch('Faces',f,'Vertices',v,...
    'EdgeColor', C3,'FaceColor','none','LineWidth',0.5, 'LineStyle','--')
set(gca, 'Clipping', 'off')

%---------------- Figure 6 - figure supplement 1C ----------
%--------------------Intracellular Cl changes-------------------

clear
size = 7;
width = 0.18;

dy = 0.007;
dy1 = -0.02;
dy2 = -0.01;
dx3 = 0.03;

h = 0.02;
C1 = [255 166 0]/255; %green
C2 = [188 80 144]/255; %red
C3 = [0 63 92]/255; %blue

load_model_data_Cl

dt = 2e-4;
t1 = (1); %signal range
t2 = (6e5);
V = VP(t1:t2); %voltage membrane potential for detection
size = 7;

%------ burst offset-------
threshold_off = -20;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_off = find((V > threshold_off) > 0);
%Interspike intervals
ISI_off  = t(Ind_off(2:end))-t(Ind_off(1:end-1));
%Only interspike intervals > 0.1s, otherwise they are within a single burst
minimal_ISI_off = 0.1;
Index_off = find(ISI_off > minimal_ISI_off);

%------ burst onset-------

threshold_on = -5;
%Time samples corresponding to spikes detected based on voltage threshold
Ind_on = find((V > threshold_on) > 0);
%Interspike intervals
ISI_on  = t(Ind_on(2:end))-t(Ind_on(1:end-1));
%Only interspike intervals >  0.1s, otherwise they are within a single burst
minimal_ISI_on = 0.1;
Index_on = find(ISI_on > minimal_ISI_on);

Index_range_off = 61:length(Index_off);
Index_range_on = (length(Index_on)-length(Index_range_off)+1):length(Index_on);

%Interburst intervals - distance from previous burst offset to next burst onset
IBI(1:length(Index_range_on)-1) = t(Ind_on(Index_on(Index_range_on(2:end))))-t(Ind_off(Index_off(Index_range_off(1:end-1))));
IBI(length(Index_range_on)) = t(Ind_on(end))-t(Ind_off(Index_off(Index_range_off(end))));
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';

%----------------------------------plots----------------------------
h15 = subplot(7,3,3);
subplot('Position',[0.6916+dx3 0.8483+3*dy-dy1 width 0.0764-h])

plot(t, VP,'k', 'LineWidth', 0.1)
hold on

plot([t(Ind_off(Index_off(Index_range_off))) t(Ind_off(Index_off(Index_range_off)))]+t(t1), [10 15], 'k','LineWidth', 0.05)
plot([0 0]+t(t1)+t(Ind_off(end)), [10 15], 'k','LineWidth', 0.05)% last burst

plot([0 0] + 50, [-70 2], 'b','LineWidth', 0.3)
plot([0 0] + 107.5, [-70 2], 'b','LineWidth', 0.3)

axis([0 120 -70 15])
set(gca,'Fontsize', size)
box off
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('V_{PY} (mV)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom') 
text(-35,60, 'C','Fontsize', 9, 'FontWeight', 'Bold');
text(0,40, 'IBI evolution - [Cl]_i change','Fontsize', 8, 'FontWeight', 'Normal');

subplot('Position',[0.6916+dx3 0.7270+2*dy-dy1-dy2 width 0.0764-h])
plot(t, K_soma,'k', t, K_dend, '-.k')
set(gca, 'Fontsize', size)
ylabel('[K]_o (mM)', 'Fontsize', size)
axis([0 120 3 13])
box off
hold on
%--------legend------
text(68,10.6,'soma', 'Fontsize', size-1)
text(68,6.8,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [3 13], 'b','LineWidth', 0.3)
plot([0 0] + 107.5, [3 13], 'b','LineWidth', 0.3)

subplot('Position',[0.6916+dx3 0.6057+dy-dy1-2*dy2 width 0.0764-h])
plot(t, Na_soma,'k', t, Na_dend,'-.k')
set(gca, 'Fontsize', size)
ylabel('[Na]_i (mM)', 'Fontsize', size)
axis([0 120 9.5 13])
box off

%--------legend------
hold on
text(71,12.5,'soma', 'Fontsize', size-1)
text(71,11.5,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [9.5 18], 'b','LineWidth', 0.3)
plot([0 0] + 107.5, [9.5 18], 'b','LineWidth', 0.3)

subplot('Position',[0.6916+dx3 0.4845-dy1-3*dy2 width 0.0764-h])
plot(t, Cl_soma,'k', t, Cl_dend,'-.k')
set(gca, 'Fontsize', size)
ylabel('[Cl]_i (mM)', 'Fontsize', size)
axis([0 120 4 8])
box off

%--------legend------
hold on
text(71,7.2,'soma', 'Fontsize', size-1)
text(71,6.5,'dend', 'Fontsize', size-1)
%--------end legend------

plot([0 0] + 50, [4 8], 'b','LineWidth', 0.3)
plot([0 0] + 107.5, [4 8], 'b','LineWidth', 0.3)

%--------------------Intracellular Cl changes-------------------
%--------------------Linear function fitting-------------------

subplot('Position',[0.6916+dx3 0.3632-dy-dy1-4*dy2 width 0.0764-h])
plot(x,y,'k.')
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
grid
set(gca, 'Fontsize', size)
box off
hold on
c = polyfit(x,y,1);
y_est = polyval(c,x);
plot(x,y_est,'r','LineWidth',1)
axis([48 110 0 1])

%RMSE
ErrorVector_linear = y_est - y;
sse_linear = sum(ErrorVector_linear .^ 2);
RMS_linear = sqrt(sse_linear/length(x));

text(82,0.14, ['RMSE ' num2str(RMS_linear,3)],'Fontsize',size)

%--------------------Intracellular Cl changes-------------------
%--------------------Exponential function fitting-------------------

subplot('Position',[0.6916+dx3 0.2419-2*dy-dy1-5*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xe = x;
x = x - min(x);
xval = x;
[xval, yval, est] = curve_fitting_exponential_1_optimized(x,y,xval);
semilogy(x+min(xe), y - est(1) ,'k.',xval + min(xe),yval ,'r','LineWidth',1);
hold on
grid on 
xlabel('Time (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'top')
ylabel('IBI (s), log','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([48 110 0.0001 1])
set(gcf,'color','w');
set(gca, 'Fontsize', size)
box off

%RMSE
 ErrorVector_exp = yval + est(1) - y;
 sse_exp = sum(ErrorVector_exp.^ 2);
 RMS_exp = sqrt(sse_exp/length(x));

text(82,0.00035, ['RMSE ' num2str(RMS_exp,3)],'Fontsize',size)

%--------------------Intracellular Cl changes-------------------
%--------------------1/sqrt function fitting-------------------

subplot('Position',[0.6916+dx3 0.1206-3*dy-dy1-6*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xval = max(x) - x + 1;
plot(xval, y,'k.')
grid
hold on
c = polyfit(1./sqrt(xval),y,1);
y_est = polyval(c,1./sqrt(xval));
plot(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
box off
xlabel('Time until end of SLE (s)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([0 60 0 1])

%RMSE
ErrorVector_sqrt = y_est - y;
sse_sqrt = sum(ErrorVector_sqrt.^ 2);
RMS_sqrt = sqrt(sse_sqrt/length(x));

text(27,0.15, ['RMSE ' num2str(RMS_sqrt,3)],'Fontsize',size)

%--------------------Intracellular Cl changes-------------------
%--------------------Logarithmic function fitting---------------

subplot('Position',[0.6916+dx3 0-4*dy-dy1-7*dy2 width 0.0764-h])
x = (t(Ind_on(Index_on(Index_range_on)))+t(t1));
y = IBI';
xval = max(x) - x + 1;
semilogx(xval, y,'k.')
grid on
hold on
c = polyfit(log(xval),y,1);
y_est = polyval(c,log(xval));
semilogx(xval,y_est,'r','LineWidth',1)
set(gca, 'XDir','reverse')
set(gca, 'Fontsize', size)
xlabel('Time until end of SLE (s), log','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'top')
ylabel('IBI (s)','FontSize',size, 'FontWeight', 'Normal', 'VerticalAlignment', 'bottom')
axis([0.8 80 0 1])

%RMSE
ErrorVector_log = y_est - y;
sse_log = sum(ErrorVector_log.^ 2);
RMS_log = sqrt(sse_log/length(x));

text(6,0.18,['RMSE ' num2str(RMS_log,3)],'Fontsize',size)

box off
v = [275 -0.8; 275 1.25; 0.6 1.25; 0.6 -0.8];
f = [1 2 3 4];
patch('Faces',f,'Vertices',v,...
    'EdgeColor', C3,'FaceColor','none','LineWidth',0.5, 'LineStyle','--')
set(gca, 'Clipping', 'off')


set(gcf,'Units','centimeters', 'Position',[10 10 18.5 18.5]) % Set figure format to 18.5 cm witdth and height 
%print -dtiff './Figure_6-figure_supplement_1.tiff' -r600



function [xval, yval,est] = curve_fitting_exponential_1_optimized(x,y,xval)

x = x(:);  % bring the data into the standard, more convenient format of column vectors
y = y(:);

Aguess = min(y) - (max(y)-min(y)) / 2;
guess = [ones(size(x)), -x] \ log(y - Aguess);
Bguess = exp(guess(1));
Cguess = guess(2);

start_point = [Aguess, Bguess, Cguess];
est = fminsearch(@expfun, start_point);

    function [sse, FittedCurve] = expfun(params)
        A = params(1);
        B = params(2);
        C = params(3);
        FittedCurve = A + B .* exp(-C * x);
        ErrorVector_exp = FittedCurve - y;
        sse = sum(ErrorVector_exp .^ 2);
      end

%yval = est(1)+est(2) * exp(-est(3) * xval);

yval = est(2) * exp(-est(3) * xval);
end
