
hidden off
clf
close all

load_model_data

size = 8;
height = 0.08;
width = 0.46;

dy = -0.01;
dx1 = 0.;

xt = -0.28;
yt = 1.65;

xt1 = 0.05;
yt1 = 1.7;

h = -0.01;

C1 = [255 166 0]/255; %green
C2 = [188 80 144]/255; %red
C3 = [0 63 92]/255; %blue

subplot('Position',[0.13-dx1 0.84-dy 0.77 0.0691-h])
plot(t,LFP_sim,'k', 'LineWidth', 0.3)
xlim([0 300])
ylim([-0.2 0.1])
ylabel('LFP (mV)','FontSize',size, 'FontWeight', 'Normal','VerticalAlignment', 'bottom') 
set(gca, 'Fontsize', size)
box off
text(-35, 0.23,'A','FontWeight','Bold', 'Fontsize', 9)


subplot('Position',[0.13-dx1 0.685-dy 0.77 0.0691-h])
plot(t,VP,'k', 'LineWidth', 0.3)
xlim([0 300])
ylim([-100 50])
ylabel('V_{PY} (mV)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'bottom') 
set(gca, 'Fontsize', size)
box off
text(-35, 110,'B','FontWeight','Bold', 'Fontsize', 9)


subplot('Position',[0.13-dx1 0.53-dy 0.77 0.0691-h])
plot(t,VI,'k', 'LineWidth', 0.3)
hold on
plot(t,I/0.03 - 90,'Color',C1, 'LineWidth', 0.3)

xlim([0 300])
ylim([-100 50])
hold on
ylabel('V_{IN} (mV)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'bottom')
set(gca, 'Fontsize', size)
box off
text(-35, 110,'C','FontWeight','Bold', 'Fontsize', 9)


subplot('Position',[0.13-dx1 0.375-dy 0.77 0.0691-h])
plot(t,ko_soma,'Color',C3, 'linewidth',0.3)
hold on
plot(t,ko_dend,'Color',C2, 'linewidth',0.3)
text(0.9,0.82, 'soma','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
text(0.9, 0.6,'dend','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
plot([250 265],[10 10],'Color',C3)
plot([250 265],[8.2 8.2],'Color',C2)


xlim([0 300])
ylim([3 12])
ylabel('[K]_o (mM)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'bottom')
set(gca, 'Fontsize', size)
box off
text(-35, 16,'D','FontWeight','Bold', 'Fontsize', 9)

subplot('Position',[0.13-dx1 0.22-dy 0.77 0.0691-h])
plot(t,nai_soma,'Color',C3, 'linewidth',0.3)
hold on
plot(t,nai_dend,'Color',C2, 'linewidth',0.3)
text(0.9,0.92, 'soma','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
text(0.9, 0.7,'dend','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
plot([250 265],[13.5 13.5],'Color',C3)
plot([250 265],[12.5 12.5],'Color',C2)
set(gca, 'Fontsize', size)
ylabel('[Na]_i (mM)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'bottom')
xlim([0 300])
ylim([9.5 14])
box off
text(-35, 17,'E','FontWeight','Bold', 'Fontsize', 9)


subplot('Position',[0.13-dx1 0.065-dy 0.77 0.0691-h])
set(gca, 'Fontsize', size)
plot(t,cli_soma,'Color',C3, 'linewidth',0.3)
hold on
plot(t,cli_dend,'Color',C2, 'linewidth',0.3)
text(0.9,0.92, 'soma','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
text(0.9, 0.7,'dend','Fontsize', size-2, 'FontWeight', 'Normal','Units', 'normalized');
plot([250 265],[8.7 8.7],'Color',C3)
plot([250 265],[8 8],'Color',C2)
set(gca, 'Fontsize', size)
box off
ylabel('[Cl]_i (mM)','FontSize',size,'FontWeight', 'Normal','VerticalAlignment', 'bottom')
xlabel('Time (s)','FontSize',size,'FontWeight', 'Normal', 'VerticalAlignment', 'top')
xlim([0 300])
ylim([6 9])
text(-35, 10,'F','FontWeight','Bold', 'Fontsize', 9)
hold on
set(gca,'Clipping','Off')
line([60 60], [6 39],'Color','black','LineStyle','--','LineWidth',0.3);
line([67.5 67.5], [6 39],'Color','black','LineStyle','--','LineWidth',0.3);
line([80 80], [6 39],'Color','black','LineStyle','--','LineWidth',0.3);
line([121.3 121.3], [6 39],'Color','black','LineStyle','--','LineWidth',0.3);
line([221.3 221.3], [6 39],'Color','black','LineStyle','--','LineWidth',0.3);
text_fontsize = 8;
text(60.5, 38.5, 'LVF','Fontsize',text_fontsize)
text(69, 38.5, 'Tonic','Fontsize',text_fontsize)
text(92, 38.5, 'Bursting','Fontsize',text_fontsize)
text(165, 38.5, 'PES','Fontsize',text_fontsize)


set(gcf,'Units','centimeters', 'Position',[10 10 2*18.5 2*18.5/1.618]) % Set figure format to 37 cm witdth with a golden ratio
%set(gcf,'Units','centimeters', 'Position',[10 10 18.5 18.5/1.618]) % Set figure format to 18.5 cm witdth with a golden ratio
%print -dtiff './Figure2.tiff' -r600 %printing 

