* # table1 
tab case_control
by case_control, sort: summarize age_at_study_date
by case_control, sort: tab is_female
by case_control, sort: tab region_is_urban

by case_control, sort: tab education_2groups
by case_control, sort: tab marital_2groups
by case_control, sort: tab heart_attack_family_history_g2
by case_control, sort: summarize hours_since_last_ate

* # diet component
* 	* healthy = vegetables everyday
* 	gen diet_component1 = 1 if diet_freq_fresh_veg == 0
* 		replace diet_component1 = 0 if diet_component1 == .

* 	* healthy = fruit everyday
* 	gen diet_component2 = 1 if diet_freq_fresh_fruit == 0
* 		replace diet_component2 = 0 if diet_component2 == .

* 	* healthy = read meat less than everyday
* 	gen diet_component3 = 1 if diet_freq_meat > 0
* 		replace diet_component3 = 0 if diet_component3 == .

* 	* healthy = fish >= 1 d/week
* 	gen diet_component4 = 1 if diet_freq_fish <= 2
* 		replace diet_component4 = 0 if diet_component4 == .

* 	* healthy = soybean >= 4 d/week	
* 	gen diet_component5 = 1 if diet_freq_soybean <= 1
* 		replace diet_component5 = 0 if diet_component5 == .
		
* 	* healthy = other staple>=4 d/week
* 	gen diet_component7 = 1 if diet_freq_other_staple <=1
* 		replace diet_component7 = 0 if diet_component7 == .

* 	egen diet_6score = rowtotal(diet_component1 diet_component2 diet_component3 diet_component4 diet_component5 diet_component7)
by case_control, sort: summarize diet_6score 
by case_control, sort: tab diet_component1 
by case_control, sort: tab diet_component2 
by case_control, sort: tab diet_component3 
by case_control, sort: tab diet_component4 
by case_control, sort: tab diet_component5 
by case_control, sort: tab diet_component7 

gen smoking_subgroup=1 if (smoking_category == 4 | (smoking_category == 3 & smoking_stopped_reason == 0))
	replace smoking_subgroup=0 if smoking_subgroup==.
gen alcohol_subgroup=1 if alc_weekly == 2
	replace alcohol_subgroup=0 if alcohol_subgroup==.
by case_control, sort: tab smoking_subgroup 
by case_control, sort: tab alcohol_subgroup 
by case_control, sort: summarize met 

by case_control, sort: summarize bmi_calc 
by case_control, sort: tab has_hypertension 
by case_control, sort: tab has_diabetes 
by case_control, sort: summarize chol_mmoll 
by case_control, sort: summarize ldl_mmoll 
by case_control, sort: summarize hdl_mmoll 	
by case_control, sort: summarize tg_mmoll 	

* table 2 logistic regression to estimate ORs
use "C:\Users\sijia\Desktop\甲基化数据复核\2020-04-01 980_participants.dta"

foreach var of varlist cg23398826 cg02386575 cg10400937 cg20562821 cg08106661 cg11630610 cg20302171 cg26334131 cg07560408 cg21210537 cg15833447 cg02591826 cg16639138 cg01545454 cg07219103 cg05681643 cg06358566 cg19583211 cg10643850 cg13311494 cg11754670 cg05740632 cg08484100 cg24792179 cg22794712{
  egen s_`var'=std(`var')
  }

foreach var of varlist cg23398826 cg02386575 cg10400937 cg20562821 cg08106661 cg11630610 cg20302171 cg26334131 cg07560408 cg21210537 cg15833447 cg02591826 cg16639138 cg01545454 cg07219103 cg05681643 cg06358566 cg19583211 cg10643850 cg13311494 cg11754670 cg05740632 cg08484100 cg24792179 cg22794712{
  logistic chd s_`var' age_at_study_date is_female hours_last_ate_x10_g1 i.region_code highest_education marital_status smk drk pa1 pa2 diet_score bmi_calc sv1 sv2 sv3 sv4 sv5 sv6 sv7 sv8 sv9 sv10 sv11 sv12 sv13 sv14 sv15 sv16 sv17 sv18 sv19 sv20 sv21 sv22 sv23 sv24 sv25 sv26 sv27 sv28 sv29 sv30 sv31 sv32 sv33 sv34 sv35 sv36 sv37 sv38 sv39 sv40 sv41 sv42 sv43 sv44 sv45 sv46 sv47 sv48 sv49 sv50 sv51 sv52 sv53 sv54 sv55 sv56, cformat(%9.2f)
  }


