%  moduliloop.m
%
% http://www.pcf.leeds.ac.uk/research/highlight/view/4
%
% Polymer & Complex Fluids Group
% School of Physics & Astronomy
% University of Leeds
%
% This program converts compliance measurements into storage and loss
% moduli, using the method described by 
% R M L Evans, Manlio Tassieri, Dietmar Auhl and Thomas A Waigh in 
% Phys. Rev. E 80, 012501 (2009).
%
% Coded by Chirag Kalelkar, Complex Fluids and Polymer Engineering Group,
% National Chemical Laboratory, Pune, India,
% Modified from code by David Pearce, University of Manchester, U.K.
% Edited by R M L Evans, University of Leeds, U.K.
% 
% Inputs:
%   J_b1 = compliance data (column vector)
%   t_b1 = time data (column vector)
%   eta_b1 = the long-time viscosity = reciprocal of gradient of asymptote of J_b1(t).
%   J0_b1 = value of compliance extrapolated to time t=0.
%   dpoints = number of output points required.
%   maxfreq = upper limit of frequency range to output.
%             Should usually set this to 1/t(1).
% 
%   N.B. The user must estimate eta_b1 and J0_b1 from the data,
%   since *all* automated extrapolation procedures are flawed.
% 
% Output:
%   GData_b1(frequency, G', G")


close all;


% *************************************
% *** Edit the following two lines. ***
maxfreq = 25;
[nr, nc] = size(file2);
dpoints = nr;
M=nc/2;

J0{1} = file1(:,2);    
eta{1} = file1(:,1); 
J0{2} = file1(:,4);    
eta{2} = file1(:,3);
J0{3} = file1(:,6);    
eta{3} = file1(:,5); 
J0{4} = file1(:,8);    
eta{4} = file1(:,7);
J0{5} = file1(:,10);    
eta{5} = file1(:,9); 
J0{6} = file1(:,12);    
eta{6} = file1(:,11);
J0{7} = file1(:,14);    
eta{7} = file1(:,13); 
J0{8} = file1(:,16);    
eta{8} = file1(:,15);
J0{9} = file1(:,18);    
eta{9} = file1(:,17); 
J0{10} = file1(:,20);    
eta{10} = file1(:,19);



t{1} = file2(:,1);
J{1} = file2(:,2);
t{2} = file2(:,3);
J{2} = file2(:,4);
t{3} = file2(:,5);
J{3} = file2(:,6);
t{4} = file2(:,7);
J{4} = file2(:,8);
t{5} = file2(:,9);
J{5} = file2(:,10);
t{6} = file2(:,11);
J{6} = file2(:,12);
t{7} = file2(:,13);
J{7} = file2(:,14);
t{8} = file2(:,15);
J{8} = file2(:,16);
t{9} = file2(:,17);
J{9} = file2(:,18);
t{10} = file2(:,19);
J{10} = file2(:,20);


% Establish empty data structure to speed up computation
%GData = zeros(dpoints,3);

for k=1:M
  
  %GData = zeros(k,dpoints,3);
  % Valid frequency range is from 1/tmax to maxfreq
  frange = logspace(log10(1/t{k}(length(t{k}))),log10(maxfreq),dpoints);
  
  for ww = 1:dpoints
      w = frange(ww);
      GStar{k} = 1i*w./(1i*w*J0{k} + (1-exp(-1i*w*t{k}(1)))*(J{k}(1)-J0{k})/t{k}(1) + exp(-1i*w*t{k}(size(t{k},1)))/eta{k} + sum(diff(J{k})./diff(t{k}).*(exp(-1i*w*(t{k}(1:(size(t{k})-1))))-exp(-1i*w*(t{k}(2:size(t{k})))))));
      GData(k,ww,:) = [w real(GStar{k}) imag(GStar{k})];
  end

figure;
loglog(GData(k,:,1),GData(k,:,2),'b');
hold on
loglog(GData(k,:,1),GData(k,:,3),'r');
legend('G''','G''''','Location','NorthWest');
xlabel('\omega [s^{-1}]');
ylabel('Moduli [Pa]');


end

wf_1 = GData(1,:,1)';
Gp_1 = GData(1,:,2)';
Gpp_1 = GData(1,:,3)';
DATA_1 = [wf_1,Gp_1,Gpp_1];
wf_2 = GData(2,:,1)';
Gp_2 = GData(2,:,2)';
Gpp_2 = GData(2,:,3)';
DATA_2 = [wf_2,Gp_2,Gpp_2];
wf_3 = GData(3,:,1)';
Gp_3 = GData(3,:,2)';
Gpp_3 = GData(3,:,3)';
DATA_3 = [wf_3,Gp_3,Gpp_3];
wf_4 = GData(4,:,1)';
Gp_4 = GData(4,:,2)';
Gpp_4 = GData(4,:,3)';
DATA_4 = [wf_4,Gp_4,Gpp_4];
wf_5 = GData(5,:,1)';
Gp_5 = GData(5,:,2)';
Gpp_5 = GData(5,:,3)';
DATA_5 = [wf_5,Gp_5,Gpp_5];
wf_6 = GData(6,:,1)';
Gp_6 = GData(6,:,2)';
Gpp_6 = GData(6,:,3)';
DATA_6 = [wf_6,Gp_6,Gpp_6];
wf_7 = GData(7,:,1)';
Gp_7 = GData(7,:,2)';
Gpp_7 = GData(7,:,3)';
DATA_7 = [wf_7,Gp_7,Gpp_7];
wf_8 = GData(8,:,1)';
Gp_8 = GData(8,:,2)';
Gpp_8 = GData(8,:,3)';
DATA_8 = [wf_8,Gp_8,Gpp_8];
wf_9 = GData(9,:,1)';
Gp_9 = GData(9,:,2)';
Gpp_9 = GData(9,:,3)';
DATA_9 = [wf_9,Gp_9,Gpp_9];
wf_10 = GData(10,:,1)';
Gp_10 = GData(10,:,2)';
Gpp_10 = GData(10,:,3)';
DATA_10 = [wf_10,Gp_10,Gpp_10];

%DATA = [DATA_1,DATA_2];
%DATA = [DATA_1,DATA_2,DATA_3];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5,DATA_6];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5,DATA_6,DATA_7];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5,DATA_6,DATA_7, DATA_8];
%DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5,DATA_6,DATA_7, DATA_8,DATA_9];
DATA = [DATA_1,DATA_2,DATA_3,DATA_4,DATA_5,DATA_6,DATA_7, DATA_8,DATA_9, DATA_10];

csvwrite("AllBeads.csv",DATA);

%GDataFinal = [GData(1,:,:), GData(2,:,:)];
%csvwrite("AllBeadsTEST.csv", GData);
%Can superpose frequency sweep data if desired
%plot(freq,gprime,'.-');
%plot(freq,gdprime,'.-r');