function xdot = DDE_Tcell_Baral(t, x, par)
% Myers et al. "Dynamically Linking Influenza Virus Infection Kinetics, Lung Injury, Inflammation, and Disease Severity"
% Author, copyright 2019: Amber M Smith, UTHSC
% amber.smith@uthsc.edu
% Model from Baral et al. 

    xdot = zeros(2,1);
    
     k_1= 3.3250;
     k_2=1.5343e-05;
     I_max=1.0e6;
     k_3=1.4915; 
     k_p=9.5000;
     k_4=0.9500;
     k_e=1.9001e6;
    
    % dI/dt
    if x(1) < 0
        x(1) = 0;
        xdot(1) = 0;
    else
        xdot(1) = k_1 *x(1)*(1-x(1)/I_max)-k_2*x(1)*x(2);
    end

    % dE/dt
    if x(2) < 0
        x(2) = 0;
        xdot(2) = 0;
    else
        xdot(2)= k_3*x(1)*x(2)/(k_p+x(1))-k_4*x(1)*x(2)/(k_e+x(1));  
    end


end
