function xdot = DDE_Tcell_EDD(t, x, z, par)
% Myers et al. "Dynamically Linking Influenza Virus Infection Kinetics, Lung Injury, Inflammation, and Disease Severity"
% Author, copyright 2019: Amber M Smith, UTHSC
% amber.smith@uthsc.edu
% Model with density-dependence in E

    xdot = zeros(6,1);
    Z_tauE = z(3,1);
    Z_tauM = z(5,2);
    
    % Virus
    p = par(1);
    c = par(2);
    beta = par(3);
    k = par(4);
    delta = par(5);
    delta_E = par(6);
    Kd = par(7);
    
    % T cells
    xi = par(8);
    K_E = par(9);
    eta = par(10);
    d_E = par(11);
    zeta = par(12);
    

    if Z_tauE < 0
        Z_tauE = 0;
    end
    if Z_tauM < 0
        Z_tauM = 0;
    end
    
    % dT/dt
    if x(1) < 0
        x(1) = 0;
        xdot(1) = 0;
    else
        xdot(1) = -beta*x(4)*x(1); 
    end

    % dI1/dt
    if x(2) < 0
        x(2) = 0;
        xdot(2) = 0;
    else
        xdot(2) = beta*x(4)*x(1) - k*x(2);
    end

    % dI2/dt
    if x(3) < 0
        x(3) = 0;
        xdot(3) = 0;
    else
        xdot(3) = k*x(2) - delta*x(3) - delta_E*x(5)*x(3);
    end

    % dV/dt
    if x(4) < 0
        x(4) = 0;
        xdot(4) = 0;
    else
        xdot(4) = p*x(3) - c*x(4);
    end

    % dE/dt
    if x(5) < 0
        x(5) = 0;
        xdot(5) = 0;
    else
        xdot(5) = xi*Z_tauE/(Kd + x(3)) - d_E*x(5);
    end
    
    % dE_M/dt
    if x(6) < 0
        x(6) = 0;
        xdot(6) = 0;
    else
        xdot(6) = zeta*Z_tauM;
    end
    

end
