% Myers et al. "Dynamically Linking Influenza Virus Infection Kinetics, Lung Injury, Inflammation, and Disease Severity"
% Figures 2, A2, S2-S3
% Author, copyright 2019: Amber M Smith, UTHSC
% amber.smith@uthsc.edu


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear all
warning off;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tmax = 12;
tscat = [1/6,1:tmax];
tscat2 = [0,1:tmax];

bounds = importdata('TC1_Bounds.csv');
bounds = bounds.data;
upbd = bounds(1:15,2)';
lowbd = bounds(1:15,1)';
for i = [5,6,11,12]
    lowbd(i) = 0;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%95 CIs
nparams = 15;
chidata = importdata('ChiSquare.txt');
chiparams = chidata;
chiparams = chiparams(:, 1:16);
chioutput = chiparams(:,2:end);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

N = size(chiparams,1);
w=0;
m=0;

paramnames = {'Log$_{10}$ $p$', 'Log$_{10}$ $c$', 'Log$_{10}$ $\beta$', '$k$', '$\delta$', '$\delta_E$','Log$_{10}$ $K_{\delta_E}$','Log$_{10}$ $\xi$','Log$_{10}$ $K_E$','Log$_{10}$ $\eta$','$d_E$','$\zeta$','Log$_{10}$ $\hat{E}_{0}$','$\tau_E$','$\tau_M$'};

chioutput_new = chioutput;%chiparams(:,2:end);
ntrials = size(chioutput_new,1);
tauMtix = {'3.0', '3.5', '4.0'};
deltatix = {'0.05','0.5','1.0'};
deltaEtix = {'0.01', '1.0', '2.0'};
dEtix = {'0.05', '1.0', '2.0'};
zetatix = {'0.01', '0.5', '1.0'};

par_order = [3,4,1,2,5:10,14,11,12,15,13];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Figure 2B

q=1;

figure;   xSize = 30;
X=xSize; ySize = 15;xLeft = (xSize-xSize)/2; Y=ySize; yTop = (ySize-ySize)/2; set(gcf,'PaperPosition',[xLeft yTop xSize ySize]);set(gcf,'Position',[X Y xSize*50 ySize*50]); hold on; 
box on
for i = 1:nparams %
    ivar = par_order(i);
    subplot(3,5,q);
    box on;
    h = histogram(chioutput_new(:,ivar),'Linewidth',1,'Numbins',150); hold on;
    h.FaceColor = [0 0 0]; hold on;
    h.EdgeColor = 'k';  hold on;
    xlabel(paramnames{ivar},'interpreter','latex','fontname','times'); hold on;
    ylabel('Frequency','fontname','times'); hold on;
    set(gca,'Xlim',[lowbd(ivar) upbd(ivar)],'FontSize',27,'linewidth',1.5,'fontname','times');
    switch ivar
     case {5}
         set(gca,'XTickLabel',deltatix);
     case {6}
         set(gca,'XTickLabel',deltaEtix);
     case {11}
         set(gca,'XTickLabel',dEtix);
     case {12}
         set(gca,'XTickLabel',zetatix);
     case {15}
         set(gca,'XTickLabel',tauMtix);
        otherwise
    end
    box on
    hold off
    q = q+1;
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Figures S1-S2

q=1;
sp_lim = 36;

figure;   xSize = 30;
X=xSize; ySize = 30;xLeft = (xSize-xSize)/2; Y=ySize; yTop = (ySize-ySize)/2; set(gcf,'PaperPosition',[xLeft yTop xSize ySize]);set(gcf,'Position',[X Y xSize*50 ySize*50]); hold on; 
box on
for i = 1:nparams
    ivar = par_order(i);
    for j = i+1:nparams
        jvar = par_order(j);
        if (ivar == 3 && jvar == 1) || (ivar == 3 && jvar == 2) || (ivar == 1 && jvar == 2) || (ivar == 3 && jvar == 4) || (ivar == 4 && jvar == 1) || (ivar == 4 && jvar == 2)
            fprintf('Skipping %s and %s \n',paramnames{ivar}, paramnames{jvar})
        elseif (ivar == 5 && jvar == 6) || (ivar == 10 && jvar == 11) || (ivar == 11 && jvar == 12) %|| (ivar == 8 && jvar == 14)
            fprintf('Skipping %s and %s \n',paramnames{ivar}, paramnames{jvar})
        else
             if q>sp_lim
                    q=1;
                    sp_lim = 30;
                    figure;
                    X=xSize; ySize = 30;xLeft = (xSize-xSize)/2; Y=ySize; yTop = (ySize-ySize)/2; set(gcf,'PaperPosition',[xLeft yTop xSize ySize]);set(gcf,'Position',[X Y xSize*50 ySize*50]); hold on; box on  
                else
                    q=q;
             end
         subplot(6,6,q);
         box on;
                var1 = chioutput_new(1:ntrials,ivar); hold on;
                var2 = chioutput_new(1:ntrials,jvar); hold on;
                plot([var1], [var2], 'k.','MarkerSize', 8.5,'color',[0 0 0 0.5]); hold on;
                xlabel(paramnames{ivar},'interpreter','latex','fontname','times'); hold on;
                ylabel(paramnames{jvar},'interpreter','latex','fontname','times'); hold on;
            set(gca,'Xlim',[lowbd(ivar) upbd(ivar)],'YLim',[lowbd(jvar) upbd(jvar)],'FontSize',20,'linewidth',1.5,'fontname','times');
            switch ivar
             case {5}
                 set(gca,'XTickLabel',deltatix);
             case {6}
                 set(gca,'XTickLabel',deltaEtix);
             case {11}
                 set(gca,'XTickLabel',dEtix);
             case {12}
                 set(gca,'XTickLabel',zetatix);
             case {15}
                 set(gca,'XTickLabel',tauMtix);
                otherwise
            end
            switch jvar
               case {5}
                 set(gca,'YTickLabel',deltatix);
               case {6}
                 set(gca,'YTickLabel',deltaEtix);
               case {11}
                 set(gca,'YTickLabel',dEtix);
               case {12}
                 set(gca,'YTickLabel',zetatix);
               case {15}
                 set(gca,'YTickLabel',tauMtix);
                otherwise
            end
            box on
            hold off
            q = q+1;
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Figures 2A & A2

par_2D_singles_sp = [5,6,4,0;
    10,12,5,0;
    13,12,10,0;
    3,4,1,1;
    3,1,6,1;
    4,1,7,1;
    3,2,11,1;
    4,2,12,1;
    1,2,13,1];

DDchidata = importdata('DDparameters95CI.txt'); % p c beta k deltad Kd cost
for i = 1:2073
    DDchidata(i,7) = DDchidata(i,5)/DDchidata(i,6);
end
DDchidata(:,8:15) = 0;
for i = [1,2,3,5,6,7]
    DDchidata(:,i) = log10(DDchidata(:,i));
end


figure;   xSize = 30;
X=xSize; ySize = 15;xLeft = (xSize-xSize)/2; Y=ySize; yTop = (ySize-ySize)/2; set(gcf,'PaperPosition',[xLeft yTop xSize ySize]);set(gcf,'Position',[X Y xSize*50 ySize*50]); hold on; 
box on
for i = 1:size(par_2D_singles_sp,1)
    ivar = par_2D_singles_sp(i,1);
    jvar = par_2D_singles_sp(i,2);
    q = par_2D_singles_sp(i,3);
    ivar = par_order(ivar); jvar = par_order(jvar); 
    subplot(3,5,q);
     box on
     var1 = chioutput_new(1:ntrials,ivar); hold on;
     var2 = chioutput_new(1:ntrials,jvar); hold on;
     if par_2D_singles_sp(i,4) == 1
        var1DD = DDchidata(:,ivar); hold on;
        var2DD = DDchidata(:,jvar); hold on;
        plot([var1DD], [var2DD], 'r.','MarkerSize', 8.5,'color',[1 0 0 0.5]); hold on;
     end
     plot([var1], [var2], 'k.','MarkerSize', 8.5,'color',[0 0 0 0.5]); hold on;
     xlabel(paramnames{ivar},'interpreter','latex','fontname','times'); hold on;
     ylabel(paramnames{jvar},'interpreter','latex','fontname','times'); hold on;
     set(gca,'Xlim',[lowbd(ivar) upbd(ivar)],'YLim',[lowbd(jvar) upbd(jvar)],'FontSize',27,'linewidth',1.5,'fontname','times');    
     switch ivar
         case {5}
             set(gca,'XTickLabel',deltatix);
         case {6}
             set(gca,'XTickLabel',deltaEtix);
         case {11}
             set(gca,'XTickLabel',dEtix);
         case {12}
             set(gca,'XTickLabel',zetatix);
         case {15}
             set(gca,'XTickLabel',tauMtix);
         otherwise
     end
    switch jvar
       case {5}
         set(gca,'YTickLabel',deltatix);
       case {6}
         set(gca,'YTickLabel',deltaEtix);
         yh = get(gca,'ylabel');
         pos = get(yh,'Position');
       case {11}
         set(gca,'YTickLabel',dEtix);
         yh = get(gca,'ylabel');
         pos = get(yh,'Position');
       case {12}
         set(gca,'YTickLabel',zetatix);
       case {15}
         set(gca,'YTickLabel',tauMtix);
        otherwise
    end
        box on
        hold off
end


