function [ V_clear ] = TimeVirusCleared( tspan, Vbest, Vthresh )
% Myers et al. "Dynamically Linking Influenza Virus Infection Kinetics, Lung Injury, Inflammation, and Disease Severity"
% Author, copyright 2019: Amber M Smith, UTHSC
% amber.smith@uthsc.edu

% finds the time (d pi) at which the virus is cleared (V goes below 1)
s = size(tspan,2);
s = round(s/8);
V_mat = [tspan(s:end); Vbest(s:end)'];
V_low = V_mat(:,(V_mat(2,:)< Vthresh));
size(V_low);
V_clear = V_low(1,1);

end

