%%N Vs B, & Class-Specific correlation for P(Choice) and RPE
%  randomized permutation and and nanparametric stats for class specific
%  and broad vs narrow

%Kia Banaie Boroujeni....2020
%%%-----------------------------%%%

clear
close all
clc,

% loading matrix for each area during each time period : Rew: reward time, F2: Feature2 onset
   load('RewACC.mat') % file for RPE in the ACC
%  load('RewPFC.mat') % file for RPE in the LPFC
%  load('F2ACC.mat')  % file for p(Choice) in the ACC
%  load('F2PFC.mat')  % file for p(Choice) in the LPFC

Ttl='RPE-REW-ACC' %title of the result

classN={'B5','B4','B3','B2','B1','N3','N2','N1'}; % Class names

% return
On_t=find(Xd>200 & Xd<500); % the window for time resolved analysis was forward looking so it starts from 200ms





% Statistics for finding significant differences between broad and narrow
% classes
for i=1:1000
    perm_t=randperm(length(Cr_Label ));
    permlbl=Cr_Label(perm_t);
    brd=find(permlbl<6); %Broad Classes
    nar=find(permlbl>5); %Narrow classes
    Bs(i,:)=nanmean(Cr_rval(nar,:),1)-nanmean(Cr_rval(brd,:),1);
    for j=1:8
        lCl=find(permlbl==j);
        lnCl=find(permlbl~=j);
        Bc{j}(i,:)=nanmean(Cr_rval(lCl,:),1)-nanmean(Cr_rval(lnCl,:),1);
    end
    
end
subplot(2,2,1)

%Selecting 2.5% extreme of extreme 2.5% for both classes and also broad
%Second level of selecting the 2.5% extreme of the 2.5% extreme
l_CI=prctile(Bs,2.5,1);
h_CI=prctile(Bs,97.5,1);
L_CI=prctile(l_CI,2.5,2);
H_CI=prctile(h_CI,97.5,2);

for j=1:8
    l_CIc=prctile(Bc{j},2.5,1);
    h_CIc=prctile(Bc{j},97.5,1);
    L_CIc(j)=prctile(l_CIc,2.5,2);
    H_CIc(j)=prctile(h_CIc,97.5,2);
end

% another threshold based on the 2 times of standard deviation of the samples
Mbs=nanmean(Bs,1);
Sd=2*nanstd(Bs,[],1);
shadedErrorBar(Xd,Mbs,Sd,'k',1);

hold on
plot(Xd,l_CI,'b')
plot(Xd,h_CI,'b')
brd=find(Cr_Label <6);
nar=find(Cr_Label >5);
Cdif=nanmean(Cr_rval (nar,:),1)-nanmean(Cr_rval (brd,:),1);
plot(Xd,Cdif,'r')
set(gca,'ylim',[-.2 .2])
plot(get(gca,'xlim'),[H_CI H_CI],'color',[.2 .2 .2],'linewidth',1,'linestyle','-')
plot(get(gca,'xlim'),[L_CI L_CI],'color',[.2 .2 .2],'linewidth',1,'linestyle','-')
plot([0 0],get(gca,'ylim'),'color',[.5 .5 .5],'linewidth',.5,'linestyle','--')

set(gca,'Tickdir','out','FontName','Arial','FontSize',12)

set(gca,'xlim',[-600 1000])
sig_a=find(Cdif>H_CI | Cdif<L_CI);

subplot(2,2,2)

Mb=nanmean(Cr_rval(brd,:),1);
SDb=nanstd(Cr_rval(brd,:),[],1)./sqrt(length(brd));
shadedErrorBar(Xd,Mb,SDb,'b',1);
hold on
Mn=nanmean(Cr_rval(nar,:),1);
SDn=nanstd(Cr_rval(nar,:),[],1)./sqrt(length(nar));
shadedErrorBar(Xd,Mn,SDn,'r',1);


set(gca,'ylim',[-.2 .2])
set(gca,'xlim',[-600 1000])
hold on
plot([0 0],get(gca,'ylim'),'color','k','linestyle','--')
plot(get(gca,'xlim'),[0 0],'color','k','linestyle','--')
set(gca,'Tickdir','out','FontName','Arial','FontSize',12)
plot(Xd(sig_a),.15*ones(1,length(sig_a)),'color','k','linewidth',1)
title([Ttl])


Cnum=1:8;
figure
for i=1:8
    Lj=find(Cr_Label ==i);
    [~,C_p{i,1}]=min(Cr_Pval (Lj,On_t+2),[],2);
    C_r{i,1}=nanmedian(Cr_rval (Lj,On_t(1)+C_p{i,1}:On_t(1)+C_p{i,1}+4),2);
    %     C_r{i,1}=nanmedian(Cr_rval (Lj,On_t),2);
end
for i=1:8
    MD=nanmean(C_r{i,1});
    nCnum=Cnum(Cnum~=i);
    Lj=find(Cr_Label ==i);
    non_C=cell2mat(C_r(nCnum,:));
    MDnC=nanmean(non_C);
    CSD=nanstd(C_r{i,1})/sqrt(length(Lj));
    if i<6
        plot([i i],[MD+CSD MD-CSD],'color',[.2 .2 .8],'linewidth',1)
        hold on
        scatter(i,MD,24,'markerfacecolor',[.2 .2 .8],'markeredgecolor',[.2 .2 .8])
        if MD-MDnC >H_CIc(i) || MD-MDnC<L_CIc(i)
            scatter(i,.18,24,'marker','*','markerfacecolor',[.2 .2 .8],'markeredgecolor',[.2 .2 .8])
            
        end
        
    else
        plot([i i],[MD+CSD MD-CSD],'color',[.8 .2 .2],'linewidth',1)
        scatter(i,MD,24,'markerfacecolor',[.8 .2 .2],'markeredgecolor',[.8 .2 .2])
        if MD-MDnC >H_CIc(i) || MD-MDnC<L_CIc(i)
            scatter(i,.18,24,'marker','*','markerfacecolor',[.8 .2 .2],'markeredgecolor',[.8 .2 .2])
            
        end
    end
    
    
end
set(gca,'Tickdir','out','FontName','Arial','FontSize',12)
set(gca,'ylim',[-.2 .2])
set(gca,'xlim',[0 9])
set(gca,'xTick',[1:8])
set(gca,'xTicklabel',classN)
plot(get(gca,'xlim'),[0 0],'color','k','linestyle','--')
all=cell2mat(C_r);
all_M=nanmedian(all);
all_SD=nanstd(all)/sqrt(length(all));
%  all_SD=nanstd(all);
plot(get(gca,'xlim'),[all_M+all_SD all_M+all_SD],'color','k','linestyle','-.')
plot(get(gca,'xlim'),[all_M-all_SD all_M-all_SD],'color','k','linestyle','-.')

[p,tbl,stats]=kruskalwallis(all,Cr_Label )
c = multcompare(stats)
