﻿#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.


// Function that uses the s.e.m. for a given set of data to randomly generate a new set of data from
// the distribution.  Then it does a fit to this generated data to extract a time constant (or some
// other parameter).  It saves the time constant and does this many times to make a list of time
// constants.  This can be used for t-tests, etc. with other data.  
//
Function GenerateFitList(dataWave, dataWaveX, dataWaveSEM)

	wave dataWave
	wave dataWaveX
	wave dataWaveSEM
	
	variable numFits = 1000
	
	variable startPoint = 31
	variable fixedY0 = 0.063 //faverage(dataWave,0,startPoint-1) // change back to -1!
	make/O/N=3 coeffWave
	wave coeffWave
	coeffWave[0] = fixedY0
	
	variable numPoints = dimsize(dataWave,0)
	
	// Fit the actual data first and print (?) the time constant
	CurveFit/Q/H="100" exp_XOffset, kwCWave=coeffWave, dataWave[startPoint,] /X=dataWaveX /D 
	print "tau = " + num2str(coeffWave[2]) + " s"
	
	variable i, j
	make/O/N=(numFits) fitResults
	make/O/N=(numFits) fitResultsHIST
	wave fitResults
	for(i=0;i<numFits;i+=1)
		
		make/O/N=(numPoints-startPoint) generatedData
		wave generatedData
		
		for(j=0;j<(numPoints-startPoint);j+=1)
		
			generatedData[j] = dataWave[j+startPoint] + gnoise(dataWaveSEM[j+startPoint])
		
		endfor
		
		CurveFit/Q/H="100" exp_XOffset, kwCWave=coeffWave, generatedData /D
		//print "tau(" + num2str(i+1) + ") = " + num2str(coeffWave[2]) + " s"
		
		fitResults[i] = coeffWave[2]
	
	
	endfor
	
	display generatedData
	Histogram fitResults, fitResultsHIST
	//wave W_hist
	//display W_hist
	display fitresultsHIST
	print "avg fit = " + num2str(mean(fitResults)) + " +/- " + num2str(sqrt(variance(fitResults)))

	
	
End // of GenerateFitList2 function



// Modifying to work with RE-sensitization specifically
Function GenerateFitList2(dataWave, dataWaveX, dataWaveSEM, fixedA)

	wave dataWave
	wave dataWaveX
	wave dataWaveSEM
	//
	variable fixedA
	
	variable numFits = 1000
	
	//variable startPoint = 14
	//variable fixedY0 = faverage(dataWave,0,startPoint-1) // change back to -1!
	make/O/N=3 coeffWave
	wave coeffWave
	coeffWave[0] = 1
	coeffWave[1] = fixedA
	
	variable numPoints = dimsize(dataWave,0)
	
	// Fit the actual data first and print (?) the time constant
	CurveFit/Q/H="110" exp_XOffset, kwCWave=coeffWave, dataWave /X=dataWaveX /D 
	print "tau = " + num2str(coeffWave[2]) + " s"
	
	variable i, j
	make/O/N=(numFits) fitResults
	make/O/N=(numFits) fitResultsHIST
	wave fitResults
	for(i=0;i<numFits;i+=1)
		
		make/O/N=(numPoints) generatedData
		wave generatedData
		
		for(j=0;j<(numPoints);j+=1)
		
			generatedData[j] = dataWave[j] + gnoise(dataWaveSEM[j])
		
		endfor
		
		CurveFit/Q/H="110" exp_XOffset, kwCWave=coeffWave, generatedData /X=dataWaveX /D
		//print "tau(" + num2str(i+1) + ") = " + num2str(coeffWave[2]) + " s"
		
		fitResults[i] = coeffWave[2]
	
	
	endfor
	
	display generatedData
	Histogram fitResults, fitResultsHIST
	//wave W_hist
	//display W_hist
	display fitresultsHIST
	print "avg fit = " + num2str(mean(fitResults)) + " +/- " + num2str(sqrt(variance(fitResults)))
	
	
End // of GenerateFitList2 function