
%% parameters (same as in comparison_TF_abundance_diffusion_limit_20210314.m)

l_Tu = 394;
l_aaRS = 987;  
l_ribo = 7300; 
l_30S = 3108; %Wittmann 1982
l_Ts = 283;
l_G = 704;
l_P = 188;
l_IF1 = 72;
l_IF2 = 890;
l_IF3 = 180;
l_RF1 = 362;
l_RF4 = 185;
l_av = 200;

l_TC = 394*1.6;
% taking molecular weight of tRNA + Tu = 68 kDa, converting back to a.a.
% tRNA ~ 25 kDa
% EF-Tu ~ 43 kDa 


% diffusion constants um^2/s
D_subunit = 0.25;   % Bakshi2012, Sanamrad2014
D_ribo = 0.05;      % Bakshi2012, Sanamrad2014
D_TC = 3;           % Volkov 2018
D_tRNA = 8;         % Volkov2018, Plochowietz2017
D_G = D_TC*(l_G/l_TC)^(-1/3);
D_aaRS = D_TC*(l_aaRS/l_TC)^(-1/3);
D_Ts = D_TC*(l_Ts/l_TC)^(-1/3);
D_IF1 = D_TC*(l_IF1/l_TC)^(-1/3);
D_IF2 = D_TC*(l_IF2/l_TC)^(-1/3);
D_IF3 = D_TC*(l_IF3/l_TC)^(-1/3);
D_RF1 = D_TC*(l_RF1/l_TC)^(-1/3);
D_RF4 = D_TC*(l_RF4/l_TC)^(-1/3);
D_Tu = D_TC*(l_Tu/l_TC)^(-1/3);



n_aa = 20;       % correction factor for the coarse-graining

% association rates anchored to that of ternary complex
k_on_TC =   6.4;          % Value from Dai et al, 2016. uM^-1 s^-1
k_on_G =    k_on_TC*(D_G+D_ribo)/(D_TC+D_ribo);
k_on_aaRS = k_on_TC*(D_tRNA+D_aaRS)/(D_TC+D_ribo);    % assume similar diffusion of aaRS and tRNA to get factor of 2 (factor of 2 since both components diffusings).
k_on_RF1 =  k_on_TC*(D_RF1+D_ribo)/(D_TC+D_ribo);
k_on_RF4 =  k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);
k_on_Ts =   k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);

k_on_IF1 = k_on_TC*(D_IF1+D_subunit)/(D_TC+D_ribo);
k_on_IF2 = k_on_TC*(D_IF2+D_subunit)/(D_TC+D_ribo);
k_on_IF3 = k_on_TC*(D_IF3+D_subunit)/(D_TC+D_ribo);
k_on_50S = k_on_TC*(D_subunit+D_subunit)/(D_TC+D_ribo); % new addition



%%
phi_ribo = 0.211;    % proteome fraction to ribosome
lambda = log(2)/(21*60);    % growth rate in s^-1;

tRNA_to_ribo =6.5;

phi_aaRS_exp = 0.03;    % total proteome fraction to aaRS
phi_Tu_exp = 0.05;      % total proteome fraction to EF-Tu
P = 2.5E6;  % in units of uM: total in-protein a.a. concentration --> for conversion to concentration: phi_A = l_A*[A]/P where l_A is the number of a.a. in protein A

% catalytic rates in units of s^-2
k_el_max = 22;                  % from Dai et al, 2016.
t_rest = 0.5;         % contribution of initiation and termination
k_cat_aaRS = Inf;     % assume infinitely fast catalytic rate of aaRS


% on rates: units of uM^-1 s^-1.
k_Tu_tRNA = 6.4*(D_tRNA+D_Tu)/(D_TC+D_ribo);
k_TC = 6.4/n_aa;        % Value from Dai et al, 2016.
k_aaRS_tRNA = k_on_aaRS/n_aa;   

N_aa_Rb = 7336;
N_aa_Tu = 394;
N_aa_aaRS = l_aaRS;
N_aa_av = 200;
R_tot = phi_ribo*P/N_aa_Rb;

% tRNA budget (converted to "proteome fraction"):
t = R_tot*tRNA_to_ribo/P;
tRNA_tot = R_tot*tRNA_to_ribo;

% on-rate in units of proteome fraction
k_Tu_tRNA_p = k_Tu_tRNA*P/N_aa_Tu;
k_TC_p = k_TC*P/N_aa_Tu;               % Value from Dai et al, 2016.
k_aaRS_tRNA_p = k_aaRS_tRNA*P/N_aa_aaRS;    % assume similar diffusion of aaRS and tRNA to get factor of 2 (factor of 2 since both components diffusings).
k_trl = (N_aa_av*k_el_max)/(N_aa_av + t_rest*k_el_max);
K_TC = k_trl/k_TC_p;


% phi_aaRS = phi_aaRS_exp*logspace(-1,1,150)*0.3;
phi_aaRS = phi_aaRS_exp*logspace(-2,1,150);
phi_Tu = phi_Tu_exp*logspace(-1,1,155);


% initialization
free_Tu =   NaN(length(phi_Tu),length(phi_aaRS));
aatRNA =    NaN(length(phi_Tu),length(phi_aaRS));


tol = 1E-12;
tic
phi_TC_sol = NaN(length(phi_Tu),length(phi_aaRS));
lambda_sol = NaN(length(phi_Tu),length(phi_aaRS));

phi_max = 0.315;
phi_tRNA_proc = 0.55;
n_tRNA_obs = 6.5;

for i = 1:length(phi_Tu)
    for j = 1:length(phi_aaRS)
                 
        if phi_ribo>0
            
            lambda_fun = @(phi_TC)(phi_ribo*k_trl/N_aa_Rb*phi_TC./(phi_TC + K_TC));
            
            % equation to solve for TC
            fun = @(phi_TC)(t - phi_TC/N_aa_Tu - ...
                lambda_fun(phi_TC)*(...
                2/k_el_max + 1/(k_TC_p*phi_TC) + ...
                1/(k_aaRS_tRNA_p*(phi_aaRS(j)-N_aa_aaRS*lambda_fun(phi_TC)/k_cat_aaRS)) +...
                1/k_cat_aaRS +...
                1/(k_Tu_tRNA_p*(phi_Tu(i)-phi_TC)) ) );
            
            aaRS_div = N_aa_aaRS/N_aa_Rb*k_el_max/k_cat_aaRS*phi_ribo/phi_aaRS(j) - 1;
            
            
            if aaRS_div > 0
                phi_TC_max = min([(1-tol)*phi_Tu(i) (1-tol)*(K_TC/aaRS_div)]);
            else
                phi_TC_max = (1-tol)*phi_Tu(i);
            end
            
            % solution of equation in range of interest
            phi_TC_sol(i,j)=fzero(fun,[tol phi_TC_max]);
            lambda_sol(i,j) = lambda_fun(phi_TC_sol(i,j));
            
            aatRNA(i,j) = lambda_sol(i,j)/(k_Tu_tRNA_p*(phi_Tu(i)-phi_TC_sol(i,j)));
            free_Tu(i,j) = phi_Tu(i)-phi_TC_sol(i,j);
            
        else
            lambda_sol(i,j) = 0;
        end
        
    end
    
    if mod(i,ceil(length(phi_Tu)/10))==0
        toc
    end
end


%%
% plotting
[X,Y] = meshgrid(phi_aaRS,phi_Tu);
subplot = @(m,n,p) subtightplot (m, n, p, [0.05 0.05], [0.18 0.05], [0.05 0.01]);


lambda_fun = @(phi_TC)(phi_ribo*k_trl/N_aa_Rb*phi_TC./(phi_TC + K_TC));


t = R_tot*tRNA_to_ribo/P;

excess_tRNA = t./(lambda_fun(phi_Tu))  - 2/k_el_max  - 1./(k_TC_p*phi_Tu) - ...
    1/k_cat_aaRS - phi_Tu./(l_Tu*lambda_fun(phi_Tu));

phi_Tu_diff= sqrt(l_ribo*l_Tu*n_aa/k_on_TC)*sqrt(lambda/P);
k_on_TC_phi = k_on_TC*P/l_Tu/n_aa;


aaRS_crit = 1./(k_aaRS_tRNA_p*excess_tRNA) + N_aa_aaRS*lambda_fun(phi_Tu)/k_cat_aaRS;
aaRS_crit(phi_Tu>phi_Tu(aaRS_crit==max(aaRS_crit))) = NaN;
aaRS_crit(find(~isnan(aaRS_crit),1,'last')+1) = max(phi_aaRS);


h_fig = figure;

subplot(1,3,1)
hold on
Z = phi_TC_sol/K_TC;
surf(X,Y,Z)

plot3(aaRS_crit,phi_Tu,max(Z(:))*1.1*ones(size(phi_Tu)),'--','LineWidth',2,'Color',[249 186 0]/255);
plot3(phi_aaRS,phi_Tu_diff*ones(size(phi_aaRS)),max(Z(:))*1.1*ones(size(phi_aaRS)),'--b','LineWidth',1);


shading flat
default_plot(1)
set(gca,'XLim',[min(phi_aaRS) max(phi_aaRS)],'YLim',[min(phi_Tu) max(phi_Tu)]);
set(gca,'XTick',[1E-3 1E-2 1E-1])
view(2)
colormap('gray')
colorbar 
xlabel('\phi_{aaRS}')
ylabel('\phi_{Tu}')
title('Ternary complex')
set(gca,'FontSize',20)
set(gca,'TickDir','out');




subplot(1,3,2)
hold on
Z = log10(aatRNA*P/tRNA_tot);
surf(X,Y,Z)
plot3(aaRS_crit,phi_Tu,max(Z(:))*1.1*ones(size(phi_Tu)),'--','LineWidth',2,'Color',[249 186 0]/255);

shading flat
default_plot(1)
set(gca,'XLim',[min(phi_aaRS) max(phi_aaRS)],'YLim',[min(phi_Tu) max(phi_Tu)]);
set(gca,'XTick',[1E-3 1E-2 1E-1])
view(2)
colorbar
colormap('gray')
xlabel('\phi_{aaRS}')
ylabel('\phi_{Tu}')
title('Free aatRNA')
set(gca,'TickDir','out');
set(gca,'FontSize',20)



subplot(1,3,3)
hold on
Z = log10(free_Tu./Y);
surf(X,Y,Z)
plot3(aaRS_crit,phi_Tu,max(Z(:))*1.1*ones(size(phi_Tu)),'--','LineWidth',2,'Color',[249 186 0]/255);

shading flat
default_plot(1)
set(gca,'XLim',[min(phi_aaRS) max(phi_aaRS)],'YLim',[min(phi_Tu) max(phi_Tu)]);
set(gca,'XTick',[1E-3 1E-2 1E-1])
view(2)
colormap('gray')
colorbar
xlabel('\phi_{aaRS}')
ylabel('\phi_{Tu}')
title('Free EF-Tu fraction')
% caxis([0 0.1])
set(gca,'FontSize',20)
set(gca,'TickDir','out');

set(gcf,'Position',[16         493        1809         476]);
set(gcf,'Renderer','Painters')

