color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;
colors=[0 0 0; color_Tu; color_aaRS; color_G; color_Ts; color_IF1; color_IF2; color_IF3;color_RF4; color_RF1];

% order: 
% Ribosome
% EF-Tu
% aaRS
% EF-G
% EF-Ts
% IF2
% IF3
% IF1
% RF4
% RF1/RF2

% see compiled_data_TF_abundance_diverse_conditions_20210620.xlsx
prot_frac_data = [...
    19.53388	22.07433	21.7659	14.15759	9.89499	9.24928	13.19215	6.66107
5.40475	6.1353	6.93434	2.33758	3.52517	2.04216	6.45991	3.89793
2.48159	2.90714	3.31587	1.52763	1.81189	1.11963	1.55383	1.01148
1.98567	1.59367	2.10142	0.81727	0.86099	0.67471	0.81191	0.47938
0.56155	0.72365	0.92214	0.36849	0.36977	0.35815	0.43304	0.1982
0.22307	0.33057	0.31581	0.29034	0.1951	0.2084	0.14191	0.11191
0.12416	0.1094	0.13898	0.06165	0.07549	0.05853	0.07652	0.05397
0.07676	0.05875	0.1021	0.0177	0.03128	0.01985	0.04892	0.01859
0.13151	0.11588	0.12288	0.05207	0.08198	0.05704	0.09855	0.06576
0.13947	0.10915	0.06306	0.05488	0.05453	0.04485	0.04757	0.03176]/100;

% data_names = {'B. subtilis, LB',...
%     'E. coli, MOPS complete',...
%     'V. natriegens, LB+3% NaCl',...
%     'C. crescentus, PYE',...
%     'E. coli, MOPS minimal',...
%     'C. crescentus, M2G',...
%     'E. coli (NCM3722), M9 glucose',...
%     'E. coli (NQ1390), forced glucose limitation'};

data_names = {'\itB. subtilis,\rm LB',...
    '\itE. coli,\rm RDM',...
    '\itV. natriegens,\rm LB+3% NaCl',...
    '\itC. crescentus,\rm PYE',...
    '\itE. coli,\rm MOPS minimal',...
    '\itC. crescentus,\rm M2G',...
    '\itE. coli,\rm M9 glucose',...
    '\itE. coli,\rm forced glucose limitation'};


doubling_times =    [21 21.5 19 96 56.3 146 48 122];
d_doubling_times =  [1  0.4   1  1  0.5  5   2   3];


%%

% take E. coli MOPS complete as reference point
ref_id = 2;
y_ids=[NaN 2 3 4 8 6 9 5 7]-1;
% y_ids = 1:size(prot_frac_data,2);
y_ids(3) = [];



factor = 1.2;
fontsize = 12;

markersize= 13;
x_lims = [1E-4 4E-1];
x_plots = logspace(-4,0,10);

fig_pos =[ 623         130        1001         975];

subplot = @(m,n,p) subtightplot (m, n, p, [0.1 0.1], [0.1 0.08], [0.1 0.02]);

% all but ribo and aaRS
prot_fit = 1:10;
prot_fit([1 3]) = [];
% order: 
% 1 Ribosome
% 2 EF-Tu
% 3 aaRS
% 4 EF-G
% 5 EF-Ts
% 6 IF2
% 7 IF3
% 8 IF1
% 9 RF4
% 10 RF1/RF2

doubling_ratios = [];
scale_param =[];
d_scale_param = [];

figure
for i = 1:length(y_ids)
    
    if ~isnan(y_ids(i))
        subplot(3,ceil(length(y_ids)/3),i)
        hold on
        for j =1:size(prot_frac_data,1)
            plot(prot_frac_data(j,ref_id),prot_frac_data(j,y_ids(i)),'ok','MarkerSize',markersize,'MarkerFaceColor',colors(j,:));
        end
        plot(x_plots,x_plots,':k')
        plot(x_plots,1/sqrt(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'-k')
        plot(x_plots,1/(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'--k')
            
        doubling_ratios(i) = 1/(doubling_times(y_ids(i))/doubling_times(ref_id));
        
        d_doubling_ratio(i) = sqrt(d_doubling_times(ref_id)^2/doubling_times(ref_id)^2 + d_doubling_times(y_ids(i))^2/doubling_times(y_ids(i))^2);
        
        
        % one parameter line
        [scale_param(i),d_scale_param(i,:)] = fit_logline( squeeze(prot_frac_data(prot_fit,ref_id))', ...
            squeeze(prot_frac_data(prot_fit,y_ids(i)))');
        plot(x_plots,scale_param(i)*x_plots,'-r','LineWidth',1)

        
        xlabel(sprintf('Proteome synthesis fraction,\n %s',data_names{ref_id}))
        ylabel(sprintf('Proteome synthesis fraction,\n %s',data_names{y_ids(i)}))
        default_plot(1)
        set(gca,'XLim',x_lims,'YLim',x_lims);
        set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1],'FontSize',fontsize)
    end
   
end
set(gcf,'Position',fig_pos)


%%

scale_param2 = scale_param(2:end);
d_scale_param2 = d_scale_param(2:end,:);
doubling_ratios2 = doubling_ratios(2:end);
d_doubling_ratios2_hi = exp(log(doubling_ratios2)+d_doubling_ratio(2:end));
d_doubling_ratios2_lo = exp(log(doubling_ratios2)-d_doubling_ratio(2:end));

xlim=[0.09 1.5];
xplot = logspace(log10(min(xlim)),log10(max(xlim)),10);

fig_pos = [560   528   425   420];

figure
hold on
plot(doubling_ratios,scale_param,'ok','MarkerSize',8,'MarkerFaceColor','k')

myerrorbars_v2(doubling_ratios2,scale_param2,...
    d_doubling_ratios2_lo,d_doubling_ratios2_hi,...
    d_scale_param2(:,1),d_scale_param2(:,2),[0.6 0.6 0.6])

% myerrorbars(doubling_ratios,scale_param,...
%     NaN(size(doubling_ratios)),d_scale_param2,[0.5 0.5 0.5])

plot(xplot,xplot,'--k')
plot(xplot,sqrt(xplot),'-k')
xlabel('Growth rate ratio, \lambda_{\it i}/\lambda_{\it ref}') % {\itE. coli\rm, RDM}
ylabel('Fold-change tlF expression, \it\alpha')
default_plot(1)
set(gca,'Xlim',[xlim],'FontSize',20)
set(gcf,'Position',fig_pos)

