function [reads_codons,norm_codon_occupancy,n_gene] = compute_reads_codons(data,genome,codon_size,buffer,codons_list,winsor_cut,...
    start_forward,stop_forward,start_reverse,stop_reverse,density_thresh)


% forward strand
reads_codons = zeros(length(codons_list),1);
norm_codon_occupancy = zeros(length(codons_list),1);

n_gene = 0;

tic
for i =1:length(start_forward)
    
    range = (start_forward(i)+codon_size*buffer):(stop_forward(i)-codon_size*buffer);
    
    data_gene = squeeze(data(range,1));
    wins_data_gene = winsorize(data_gene,winsor_cut);
    
    mean_gene_reads = mean(wins_data_gene);
    
    
    n_codon_gene = zeros(length(codons_list),1);
    norm_codon_occupancy_gene = zeros(length(codons_list),1);
    
    
    for j = 1:length(range)/codon_size
        codon_range = range(1)+(codon_size*(j-1):codon_size*j-1);
        
        codon = genome(codon_range);
        codon_ind = strcmp(codons_list,codon);
        
        reads_codons(codon_ind) = ...
            reads_codons(codon_ind)+ codon_size*mean_gene_reads;
        
        if mean_gene_reads>density_thresh
            codon_range_local = 1+(codon_size*(j-1):codon_size*j-1);
            
            n_codon_gene(codon_ind) = n_codon_gene(codon_ind)+1;
            
            norm_codon_occupancy_gene(codon_ind) = ...
                norm_codon_occupancy_gene(codon_ind) + mean(wins_data_gene(codon_range_local))/mean_gene_reads;
        end
        
    end
    
    if mean_gene_reads>density_thresh
        bool = n_codon_gene>0;
        norm_codon_occupancy(bool) = norm_codon_occupancy(bool) + norm_codon_occupancy_gene(bool)./n_codon_gene(bool);
        n_gene = n_gene+1;
    end
    
    if mod(i,500)==0
        toc
    end
end


% reverse strand
for i =1:length(start_reverse)
    
    range = (start_reverse(i)+codon_size*buffer):(stop_reverse(i)-codon_size*buffer);
    
    data_gene = squeeze(data(range,2));
    wins_data_gene = winsorize(data_gene,winsor_cut);
    
    mean_gene_reads = mean(wins_data_gene);
    
    n_codon_gene = zeros(length(codons_list),1);
    norm_codon_occupancy_gene = zeros(length(codons_list),1);
    
    for j = 1:length(range)/codon_size
        codon_range = range(1)+(codon_size*(j-1):codon_size*j-1);
        
        % important change: need to reverse complement the codon.
        codon = char(RCsequence(genome(codon_range)));
        
        codon_ind =  strcmp(codons_list,codon);
        
        reads_codons(strcmp(codons_list,codon)) = ...
            reads_codons(strcmp(codons_list,codon))+ codon_size*mean_gene_reads;
        
        if mean_gene_reads>density_thresh
            
            codon_range_local = 1+(codon_size*(j-1):codon_size*j-1);
            
            n_codon_gene(codon_ind) = n_codon_gene(codon_ind)+1;
            
            norm_codon_occupancy_gene(codon_ind) = ...
                norm_codon_occupancy_gene(codon_ind) + mean(wins_data_gene(codon_range_local))/mean_gene_reads;
            
        end
    end
        
    if mean_gene_reads>density_thresh
        bool = n_codon_gene>0;
        norm_codon_occupancy(bool) = norm_codon_occupancy(bool) + norm_codon_occupancy_gene(bool)./n_codon_gene(bool);
        n_gene = n_gene+1;
    end
    
    
    if mod(i,500)==0
        toc
    end
end

norm_codon_occupancy = norm_codon_occupancy/n_gene;

end

