function [codons_list, amino_acid, synonymous_codons] = get_codon_dictionary()


%% need to generate a dictionary of codons

nucleotides = {'A','T','C','G'};

codons_list = [];
counter = 1;
for i = 1:4
    for j = 1:4
        for k = 1:4
            codons_list{counter} = [nucleotides{i} nucleotides{j} nucleotides{k}];
            counter = counter+1;
        end
    end
end

% removing stop codons 
codons_list(strcmp(codons_list,'TAA')) = [];
codons_list(strcmp(codons_list,'TGA')) = [];
codons_list(strcmp(codons_list,'TAG')) = [];



%% to compute some form of CAI, we need the list of codon for each amino acid

counter = 1;
amino_acid = [];

amino_acid.name{counter} = 'Phe';
amino_acid.codons{counter} = {'TTT','TTC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Leu';
amino_acid.codons{counter} = {'TTA','TTG','CTT','CTC','CTA','CTG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Ile';
amino_acid.codons{counter} = {'ATT','ATC','ATA'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Met';
amino_acid.codons{counter} = {'ATG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Val';
amino_acid.codons{counter} = {'GTT','GTC','GTA','GTG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Ser';
amino_acid.codons{counter} = {'TCT','TCC','TCA','TCG','AGT','AGC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Pro';
amino_acid.codons{counter} = {'CCT','CCC','CCA','CCG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Thr';
amino_acid.codons{counter} = {'ACT','ACC','ACA','ACG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Ala';
amino_acid.codons{counter} = {'GCT','GCC','GCA','GCG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Tyr';
amino_acid.codons{counter} = {'TAT','TAC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'His';
amino_acid.codons{counter} = {'CAT','CAC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Gln';
amino_acid.codons{counter} = {'CAA','CAG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Asn';
amino_acid.codons{counter} = {'AAT','AAC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Lys';
amino_acid.codons{counter} = {'AAA','AAG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Asp';
amino_acid.codons{counter} = {'GAT','GAC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Glu';
amino_acid.codons{counter} = {'GAA','GAG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Cys';
amino_acid.codons{counter} = {'TGT','TGC'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Trp';
amino_acid.codons{counter} = {'TGG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Arg';
amino_acid.codons{counter} = {'CGT','CGC','CGA','CGG','AGA','AGG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});
counter = counter+1;

amino_acid.name{counter} = 'Gly';
amino_acid.codons{counter} = {'GGT','GGC','GGA','GGG'};
amino_acid.number(counter) = numel(amino_acid.codons{counter});


%% get list of synonymous codons for each codon
synonymous_codons = [];
for i = 1:length(codons_list)
    for j = 1:length(amino_acid.name)
        if sum(strcmp(amino_acid.codons{j},codons_list{i}))>0
            for k = 1:numel(amino_acid.codons{j})
                synonymous_codons(i).names(k) = find(strcmp(codons_list,amino_acid.codons{j}{k}));
            end
        end
    end
end
