function gene_synonyms = get_gene_synonyms_UniProt(file_name,species_name,data_dir)

curr_dir = pwd;
cd(data_dir);

fid = fopen(file_name);
data = textscan(fid,'%s %s %s %s %s %s %d','Delimiter','\t','HeaderLines',1);
fclose(fid);

uniprot_ids = data{1};
gene_names = data{5};
species=  data{6};

% first restrict to B. subtilis 168
bool_species = strcmp(species,species_name);
uniprot_ids = uniprot_ids(bool_species);
gene_names = gene_names(bool_species);

% assumption, the first gene name is the correct one (in the most recent
gene_synonyms = [];

length(uniprot_ids)
for i = 1:length(uniprot_ids)
    
    % gene names in the file are separated by spaces
    spaces = find(char(gene_names(i))==' ');
    
    if isempty(spaces)
        gene_synonyms{i,1} = gene_names{i};
    else
        for j = 1:length(spaces)+1
            if j ==1
                gene_synonyms{i,j} = gene_names{i}(1:(spaces(j)-1));
            elseif j==length(spaces)+1
                gene_synonyms{i,j} = gene_names{i}(spaces(end)+1:end);
            else
                gene_synonyms{i,j} = gene_names{i}(spaces(j-1)+1:spaces(j)-1);
            end
        end
    end
   
end

cd(curr_dir)