function usable_reads = wigs_to_rRNA_tRNA_frac(data_dir,files_name,conditions,species)


rRNA_l = [];
rRNA_h = [];
tRNA_l = [];
tRNA_h = [];
rRNA_tRNA_l = [];
rRNA_tRNA_h = [];
reads = [];
buffer_window = 100;

tic
for i = 1:length(files_name)
    [reads(i), rRNA_l(i), rRNA_h(i), tRNA_l(i), tRNA_h(i),rRNA_tRNA_l(i), rRNA_tRNA_h(i)] =...
        quantifying_tRNA_rRNA_v2(data_dir,files_name{i},buffer_window,species);
    toc
end


%%

fprintf('          \t\tName \t\t M reads \t rRNA low \t rRNA high \t tRNA low \t tRNA high \t rRNA/tRNA low \t rRNA/tRNA high\t Usable M reads\n');
for i = 1:length(files_name)
    fprintf(sprintf('%-40s \t %7.3f\t %7.3f \t %7.3f \t %7.3f \t %7.3f \t %7.3f \t %7.3f\t %7.3f\n',conditions{i}, reads(i)/1E6,...
        rRNA_l(i), rRNA_h(i), tRNA_l(i), tRNA_h(i),rRNA_tRNA_l(i), rRNA_tRNA_h(i),...
        (1-0.5*(rRNA_tRNA_l(i)+rRNA_tRNA_h(i)))*reads(i)/1E6));
end

usable_reads = (1-0.5*(rRNA_tRNA_l+rRNA_tRNA_h)).*reads/1E6;
