

%% tRNA data. Compiling information from Dong et al, 1996. 
tRNA = get_tRNA_data_v2();

%% synthetase data. From RP data.
tRNA_synthetase = get_synthetase_data();
 

%% Computing the estimated new aaRS to tRNA on rate

summand = 0;
for i = 1:length(tRNA)
    % get the aaRS level corresponding to this tRNA
    for j = 1:length(tRNA_synthetase)
       if strcmp(tRNA{i}.aa_name,tRNA_synthetase{j}.aa_name)
          ind = j;
          break
       end
    end
    fprintf(sprintf('%8s\ttRNA_i = %.3f,\taaRS_i = %.3f,\t product = %.4f\n',...
        tRNA{i}.name, tRNA{i}.abundance,tRNA_synthetase{ind}.level_coli_norm,...
        tRNA{i}.abundance*tRNA_synthetase{ind}.level_coli_norm));
    summand = summand + tRNA{i}.abundance*tRNA_synthetase{ind}.level_coli_norm;
end


%% Computing the correction to the TC on rate. 
 
codon_usage = reads_codons/sum(reads_codons);
summand = 0;
tic
pairs_found = [];
for i = 1:length(codons_list)
    for j = 1:length(tRNA)
        ind = strcmp(tRNA{j}.codons_recognized,codons_list{i});
        if sum(ind)==1
            summand = summand + codon_usage(i)*tRNA{j}.abundance;
            
            pairs_found(end+1,:) = [i j find(ind) (codon_usage(i)*tRNA{j}.abundance)];
           
        end
    end
end


