

l_Tu = 394;
l_aaRS = 987;  % size_evaluation_tRNA_synthetase_20210319 
l_ribo = 7300; 
l_30S = 3108; %Wittmann 1982
l_Ts = 283;
l_G = 704;
l_P = 188;
l_IF1 = 72;
l_IF2 = 890;
l_IF3 = 180;
l_RF1 = 362;
l_RF4 = 185;
l_av = 200;

l_TC = 394*1.6; 


% taking molecular weight of tRNA + Tu = 68 kDa, converting back to a.a.... Does not make too much sense...
% tRNA ~ 25 kDa
% EF-Tu ~ 43.284 kDa 

% proteome fraction allocated to translation sector
phi_trl = 0.335; % from ribosome profiling data: species (E. coli, B. subtilis, V. natriegens) averaged summed of core TFs considered. 

% diffusion um^2/s
D_subunit = 0.25;   % Bakshi2012, Sanamrad2014
D_ribo = 0.05;      % Bakshi2012, Sanamrad2014
D_TC = 3;           % Volkov 2018
D_tRNA = 8;         % Volkov2018, Plochowietz2017
D_G = D_TC*(l_G/l_TC)^(-1/3);
D_aaRS = D_TC*(l_aaRS/l_TC)^(-1/3);
D_Ts = D_TC*(l_Ts/l_TC)^(-1/3);
D_IF1 = D_TC*(l_IF1/l_TC)^(-1/3);
D_IF2 = D_TC*(l_IF2/l_TC)^(-1/3);
D_IF3 = D_TC*(l_IF3/l_TC)^(-1/3);
D_RF1 = D_TC*(l_RF1/l_TC)^(-1/3);
D_RF4 = D_TC*(l_RF4/l_TC)^(-1/3);


lambda = log(2)/(21*60);
P = 2.5E6;

n_aa = 20;       % correction factor for the coarse-graining

k_on_TC =   6.4;          % Value from Dai et al, 2016. uM^-1 s^-1
k_on_G =    k_on_TC*(D_G+D_ribo)/(D_TC+D_ribo);
k_on_aaRS = k_on_TC*(D_tRNA+D_aaRS)/(D_TC+D_ribo);    % assume similar diffusion of aaRS and tRNA to get factor of 2 (factor of 2 since both components diffusings).
k_on_RF1 =  k_on_TC*(D_RF1+D_ribo)/(D_TC+D_ribo);
k_on_RF4 =  k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);
k_on_Ts =   k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);

k_on_IF1 = k_on_TC*(D_IF1+D_subunit)/(D_TC+D_ribo);
k_on_IF2 = k_on_TC*(D_IF2+D_subunit)/(D_TC+D_ribo);
k_on_IF3 = k_on_TC*(D_IF3+D_subunit)/(D_TC+D_ribo);
k_on_50S = k_on_TC*(D_subunit+D_subunit)/(D_TC+D_ribo); % new addition


%%
prot_frac_data = [...
    19.53388	22.07433	21.7659	14.15759	9.89499	9.24928	13.19215	6.66107
5.40475	6.1353	6.93434	2.33758	3.52517	2.04216	6.45991	3.89793
2.48159	2.90714	3.31587	1.52763	1.81189	1.11963	1.55383	1.01148
1.98567	1.59367	2.10142	0.81727	0.86099	0.67471	0.81191	0.47938
0.56155	0.72365	0.92214	0.36849	0.36977	0.35815	0.43304	0.1982
0.22307	0.33057	0.31581	0.29034	0.1951	0.2084	0.14191	0.11191
0.12416	0.1094	0.13898	0.06165	0.07549	0.05853	0.07652	0.05397
0.07676	0.05875	0.1021	0.0177	0.03128	0.01985	0.04892	0.01859
0.13151	0.11588	0.12288	0.05207	0.08198	0.05704	0.09855	0.06576
0.13947	0.10915	0.06306	0.05488	0.05453	0.04485	0.04757	0.03176]/100;


data_names = {'B. subtilis, LB',...
    'E. coli, MOPS complete',...
    'V. natriegens, LB+3% NaCl',...
    'C. crescentus, PYE',...
    'E. coli, MOPS minimal',...
    'C. crescentus, M2G',...
    'E. coli, M9 glucose',...
    'E. coli, forced glucose limitation'};

doubling_times = [21 21.5 19 96 56.3 146 48 122];

%%

% form of solution
phi_G_theo = sqrt(l_ribo*l_G/k_on_G)*sqrt(lambda/P);
phi_Ts_theo = sqrt(l_Ts*l_Tu/k_on_Ts)*sqrt(lambda/P);
phi_Tu_theo = sqrt(l_ribo*l_Tu*n_aa/k_on_TC)*sqrt(lambda/P)+phi_Ts_theo;


corr_three_stops =  1.0488; % factor from the three stop codon solution sqrt(1 + 2*sqrt(f_UAG*f_UGA))
phi_RF1_theo = sqrt(l_ribo*l_RF1/(l_av*k_on_RF1))*sqrt(lambda/P)*corr_three_stops;
phi_RF4_theo = sqrt(l_ribo*l_RF4/(l_av*k_on_RF4))*sqrt(lambda/P);

phi_123m = sqrt(l_av/k_on_50S);
phi_IF1_diff = sqrt(l_ribo*l_IF1/(l_av*k_on_IF1));

phi_IF1_theo = (sqrt(l_ribo*l_IF1/(l_av*k_on_IF1)*(1+(l_IF2+l_IF3)/l_ribo)) + l_IF1/l_av*phi_123m)*sqrt(lambda/P);
phi_IF2_theo = (sqrt(3*l_ribo*l_IF2/(4*l_av*k_on_IF2))+l_IF2/l_av*(phi_IF1_diff + phi_123m))*sqrt(lambda/P);
phi_IF3_theo = (sqrt(3*l_ribo*l_IF3/(4*l_av*k_on_IF3))+l_IF3/l_av*(phi_IF1_diff + phi_123m))*sqrt(lambda/P);

tRNA_to_ribo = 6.5; % From Dong 1996
phi_R = 0.211; % 
R_tot = phi_R*P/l_ribo;
tRNA = R_tot*tRNA_to_ribo;
k_el_max = 22;      % from Dai et al, in s^-1

% % % aaRS
phi_Tu_diff= sqrt(l_ribo*l_Tu*n_aa/k_on_TC)*sqrt(lambda/P);
k_on_TC_phi = k_on_TC*P/l_Tu/n_aa;

excess_t = tRNA/(P*lambda) - 2/k_el_max -1/(k_on_TC_phi*phi_Tu_diff) - phi_Tu_diff/(l_Tu*lambda);
phi_aaRS_theo = n_aa*l_aaRS/(P*k_on_aaRS*excess_t);


phi_ribo_theo = phi_trl - phi_Tu_theo - phi_aaRS_theo - phi_G_theo - phi_Ts_theo - ...
    phi_RF1_theo - phi_RF4_theo - ...
    phi_IF1_theo - phi_IF2_theo - phi_IF3_theo;



%%

% species averaged core TF synthesis fraction from ribosome profiling
phi_ribo_exp =  0.211247;
phi_Tu_exp =    0.0616;
phi_aaRS_exp =  0.0290;
phi_G_exp =     0.01894;
phi_Ts_exp =    0.00736;
phi_IF2_exp =   0.002898;
phi_IF1_exp =   0.000792;
phi_IF3_exp =   0.001234;
phi_RF1_exp =   0.001039;
phi_RF4_exp =   0.001234;


color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;


markersize= 13;

x_plot = [1E-4 4E-1];
figure
hold on 
plot(x_plot,x_plot,':k')

plot([0.1 0.1],0.01*[1 sqrt(n_aa*l_Tu/l_G)],'-k')
plot([0.2 0.2],0.01*[1 sqrt(l_av)],'-k')


factor = 1.2;
fontsize = 16;

plot(phi_Tu_theo,phi_Tu_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_Tu);
text(phi_Tu_theo*factor,phi_Tu_exp,'EF-Tu','Color',color_Tu,'FontWeight','bold','FontSize',fontsize);

plot(phi_aaRS_theo,phi_aaRS_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_aaRS);
text(phi_aaRS_theo*factor,phi_aaRS_exp,'aaRS','Color',color_aaRS,'FontWeight','bold','FontSize',fontsize);

plot(phi_G_theo,phi_G_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_G);
text(phi_G_theo*factor,phi_G_exp,'EF-G','Color',color_G,'FontWeight','bold','FontSize',fontsize);

plot(phi_Ts_theo,phi_Ts_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_Ts);
text(phi_Ts_theo*factor,phi_Ts_exp,'EF-Ts','Color',color_Ts,'FontWeight','bold','FontSize',fontsize);

plot(phi_RF1_theo,phi_RF1_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_RF1);
text(phi_RF1_theo*factor,phi_RF1_exp,'RF1/RF2','Color',color_RF1,'FontWeight','bold','FontSize',fontsize);

plot(phi_RF4_theo,phi_RF4_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_RF4);
text(phi_RF4_theo*factor,phi_RF4_exp,'RF4','Color',color_RF4,'FontWeight','bold','FontSize',fontsize);


plot(phi_IF1_theo,phi_IF1_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF1);
text(phi_IF1_theo*factor,phi_IF1_exp,'IF1','Color',color_IF1,'FontWeight','bold','FontSize',fontsize);

plot(phi_IF2_theo,phi_IF2_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF2);
text(phi_IF2_theo*factor,phi_IF2_exp,'IF2','Color',color_IF2,'FontWeight','bold','FontSize',fontsize);

plot(phi_IF3_theo,phi_IF3_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF3);
text(phi_IF3_theo*factor,phi_IF3_exp,'IF3','Color',color_IF3,'FontWeight','bold','FontSize',fontsize);

plot(phi_ribo_theo,phi_ribo_exp,'ok','MarkerSize',markersize,'MarkerFaceColor','k');
text(phi_ribo_theo*factor,phi_ribo_exp,'ribosome','Color','k','FontWeight','bold','FontSize',fontsize);


xlabel('Optimal proteome fraction \phi^* (theory, diffusion only)')
ylabel('Observed proteome fraction \phi')
default_plot(1)
set(gca,'XLim',x_plot,'YLim',x_plot);
set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1])
set(gcf,'Position',[549        1600         491         479]);
set(gca,'FontSize',20)












