
l_Tu = 394;
l_aaRS = 987;  % size_evaluation_tRNA_synthetase_20210319 
l_ribo = 7300; 
l_30S = 3108; %Wittmann 1982
l_Ts = 283;
l_G = 704;
l_P = 188;
l_IF1 = 72;
l_IF2 = 890;
l_IF3 = 180;
l_RF1 = 362;
l_RF4 = 185;
l_av = 200;

l_TC = 394*1.6; 


% taking molecular weight of tRNA + Tu = 68 kDa, converting back to a.a.... Does not make too much sense...
% tRNA ~ 25 kDa
% EF-Tu ~ 43.284 kDa 

% proteome fraction allocated to translation sector
% phi_trl = 0.335; % from ribosome profiling data: species (E. coli, B. subtilis, V. natriegens) averaged summed of core TFs considered. 



% diffusion um^2/s
D_subunit = 0.2; %+/- 0.1   % Bakshi2012 (D30S = 0.12), Sanamrad2014 (D50S = 0.24, D30S = 0.28, see supp table S1)
D_ribo = 0.05;      % Bakshi2012 (Dribo = 0.04), Sanamrad2014 (Dribo=0.055, see Supp table S4). 
D_TC = 3;           % Volkov 2018
D_tRNA = 8;         % Volkov2018, Plochowietz2017
D_G = D_TC*(l_G/l_TC)^(-1/3);
D_aaRS = D_TC*(l_aaRS/l_TC)^(-1/3);
D_Ts = D_TC*(l_Ts/l_TC)^(-1/3);
D_IF1 = D_TC*(l_IF1/l_TC)^(-1/3);
D_IF2 = D_TC*(l_IF2/l_TC)^(-1/3);
D_IF3 = D_TC*(l_IF3/l_TC)^(-1/3);
D_RF1 = D_TC*(l_RF1/l_TC)^(-1/3);
D_RF4 = D_TC*(l_RF4/l_TC)^(-1/3);
D_Tu = D_TC*(l_Tu/l_TC)^(-1/3);


lambda = log(2)/(21*60);
P = 2.6E6;

n_aa = 20;       % scaling factor for the coarse-graining

k_on_TC =   6.4;          % Value from Dai et al, 2016. uM^-1 s^-1
k_on_G =    k_on_TC*(D_G+D_ribo)/(D_TC+D_ribo);
k_on_aaRS = k_on_TC*(D_tRNA+D_aaRS)/(D_TC+D_ribo);    % assume similar diffusion of aaRS and tRNA to get factor of 2 (factor of 2 since both components diffusings).
k_on_RF1 =  k_on_TC*(D_RF1+D_ribo)/(D_TC+D_ribo);
k_on_RF4 =  k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);
k_on_Ts =   k_on_TC*(D_Ts+D_ribo)/(D_TC+D_ribo);


k_on_IF1 = k_on_TC*(D_IF1+D_subunit)/(D_TC+D_ribo);
k_on_IF2 = k_on_TC*(D_IF2+D_subunit)/(D_TC+D_ribo);
k_on_IF3 = k_on_TC*(D_IF3+D_subunit)/(D_TC+D_ribo);
k_on_50S = k_on_TC*(D_subunit+D_subunit)/(D_TC+D_ribo); % new addition

k_Tu_tRNA = k_on_TC*(D_tRNA+D_Tu)/(D_TC+D_ribo);


%% varying aaRS 

phi_ribo = 0.22;

% tRNA/ribo ratio
t= 6.5;

% max elongation rate
k_el_max = 22;

prot_unit_k_on_TC = k_on_TC*P/l_Tu;
prot_unit_k_on_aaRS = k_on_aaRS*P/l_aaRS/n_aa;
prot_unit_k_Tu_tRNA = k_Tu_tRNA*P/l_Tu;


K_TC = k_el_max/(prot_unit_k_on_TC/n_aa);

xlims = [0 0.1];
ylims = [0 10];

phi_Tu = 0.045;
phi_aaRS_center = 0.01;
factor=2.5;
phi_aaRS = [phi_aaRS_center/factor^2 phi_aaRS_center/factor phi_aaRS_center phi_aaRS_center*factor phi_aaRS_center*factor^2];

phi_TC = linspace(0,0.1,1E4);
norm_factor=  phi_ribo/l_ribo;

figure
set(gcf,'Position',[459         648        1205         171])

for i = 1:length(phi_aaRS)
    
    subplot(1,length(phi_aaRS),i)
    hold on
    term_tRNA_excess = (t-1)*phi_ribo/l_ribo - phi_TC/l_Tu;
    lambda_TC = phi_ribo/l_ribo*k_el_max*(phi_TC./(phi_TC+K_TC));
    term_ribo_filled_A = lambda_TC/k_el_max;
    term_free_tRNA = lambda_TC./(prot_unit_k_on_aaRS*phi_aaRS(i));
    term_charged_tRNA = lambda_TC./(prot_unit_k_Tu_tRNA*(phi_Tu-phi_TC));
    term_charged_tRNA(phi_TC>phi_Tu)=NaN;
    all_other_terms = term_ribo_filled_A+term_free_tRNA+term_charged_tRNA;
        all_other_terms = term_ribo_filled_A+term_free_tRNA+term_charged_tRNA;

    
     plot(phi_TC, term_tRNA_excess/norm_factor,'-k','LineWidth',lw)
    plot(phi_TC, term_ribo_filled_A/norm_factor,'-r','LineWidth',lw)
    plot(phi_TC, term_free_tRNA/norm_factor,'-c','LineWidth',lw)
    plot(phi_TC, term_charged_tRNA/norm_factor,'-g','LineWidth',lw)
    plot(phi_TC, all_other_terms/norm_factor,':k','LineWidth',lw)
    set(gca,'Xlim',xlims,'YLim',ylims)
    
    default_plot(0)
    
end



%% varying EF-Tu 

phi_ribo = 0.22;

% tRNA/ribo ratio
t= 6.5;

% max elongation rate
k_el_max = 22;

prot_unit_k_on_TC = k_on_TC*P/l_Tu;
prot_unit_k_on_aaRS = k_on_aaRS*P/l_aaRS;
prot_unit_k_Tu_tRNA = k_Tu_tRNA*P/l_Tu;


K_TC = k_el_max/(prot_unit_k_on_TC/n_aa);

xlims = [0 0.1];
ylims = [0 10];

phi_aaRS = 0.01; %[0.001 0.003 0.01 0.03 0.1];
factor=1.4;
phi_Tu_center = 0.045;
phi_Tu = [phi_Tu_center/factor^2 phi_Tu_center/factor phi_Tu_center phi_Tu_center*factor phi_Tu_center*factor^2];

phi_TC = linspace(0,0.1,1E4);
norm_factor=  phi_ribo/l_ribo;

figure
set(gcf,'Position',[459   125   172   980])

lw = 1.5;
for i = 1:length(phi_Tu)
    
    subplot(length(phi_Tu),1,i)
    hold on
    term_tRNA_excess = (t-1)*phi_ribo/l_ribo - phi_TC/l_Tu;
    lambda_TC = phi_ribo/l_ribo*k_el_max*(phi_TC./(phi_TC+K_TC));
    term_ribo_filled_A = lambda_TC/k_el_max;
    term_free_tRNA = lambda_TC./(prot_unit_k_on_aaRS/n_aa*phi_aaRS);
    term_charged_tRNA = lambda_TC./(prot_unit_k_Tu_tRNA*(phi_Tu(i)-phi_TC));
    term_charged_tRNA(phi_TC>phi_Tu(i))=NaN;
%     all_other_terms = term_ribo_filled_A+term_free_tRNA+term_charged_tRNA;
    all_other_terms = term_free_tRNA+term_charged_tRNA;

    
    plot(phi_TC, term_tRNA_excess/norm_factor,'-k','LineWidth',lw)
    plot(phi_TC, term_ribo_filled_A/norm_factor,'-r','LineWidth',lw)
    plot(phi_TC, term_free_tRNA/norm_factor,'-c','LineWidth',lw)
    plot(phi_TC, term_charged_tRNA/norm_factor,'-g','LineWidth',lw)
    plot(phi_TC, all_other_terms/norm_factor,':k','LineWidth',lw)
    set(gca,'Xlim',xlims,'YLim',ylims)
    
    default_plot(0)
    
end


%% varying both

phi_ribo = 0.22;

% tRNA/ribo ratio
t= 6.5;

% max elongation rate
k_el_max = 22;

prot_unit_k_on_TC = k_on_TC*P/l_Tu;
prot_unit_k_on_aaRS = k_on_aaRS*P/l_aaRS;
prot_unit_k_Tu_tRNA = k_Tu_tRNA*P/l_Tu;


K_TC = k_el_max/(prot_unit_k_on_TC/n_aa);

xlims = [0 0.1];
ylims = [0 10];

phi_aaRS = 0.01; %[0.001 0.003 0.01 0.03 0.1];'


phi_aaRS_center = 0.0085;
factor=2.5;
phi_aaRS = [phi_aaRS_center*ones(1,5) phi_aaRS_center/factor^2 phi_aaRS_center/factor phi_aaRS_center phi_aaRS_center*factor phi_aaRS_center*factor^2];


colors=brewermap(4,'Dark2');

fig_pos = [ 459         125        1043         980];

factor=1.4;
phi_Tu_center = 0.045;
phi_Tu = [phi_Tu_center/factor^2 phi_Tu_center/factor phi_Tu_center phi_Tu_center*factor phi_Tu_center*factor^2 phi_Tu_center*ones(1,5)];

phi_TC = linspace(0,0.1,1E4);
norm_factor=  phi_ribo/l_ribo;

subplot = @(m,n,p) subtightplot (m, n, p, [0.03 0.015], [0.05 0.02], [0.05 0.02]);


aaRS_col = [255 133 194]/255;
Tu_col = [255 1 0]/255;

pos_plot= [3 8 13 18 23 11 12 13 14 15];
figure
set(gcf,'Position',[459   125   172   980])

lw = 1.5;
for i = 1:length(phi_Tu)
    
    subplot(5,5,pos_plot(i))
    hold on
    
    
    lambda_TC = phi_ribo/l_ribo*k_el_max*(phi_TC./(phi_TC+K_TC));
    
%     term_TC = phi_TC/l_Tu;
    
    term_ribo_filled_A = lambda_TC/k_el_max;
    
    
    term_tRNA_excess = (t-1)*phi_ribo/l_ribo-phi_TC/l_Tu-term_ribo_filled_A;

        
        
    term_free_tRNA = lambda_TC./(prot_unit_k_on_aaRS/n_aa*phi_aaRS(i));
    term_charged_tRNA = lambda_TC./(prot_unit_k_Tu_tRNA*(phi_Tu(i)-phi_TC));
    term_charged_tRNA(phi_TC>phi_Tu(i))=NaN;
%     all_other_terms =  term_ribo_filled_A+term_free_tRNA+term_charged_tRNA;
    all_other_terms =  term_free_tRNA+term_charged_tRNA;
    
    diff_terms= abs(all_other_terms-term_tRNA_excess);
    sol = find(diff_terms==min(diff_terms));
    
    
    plot(phi_TC, term_tRNA_excess/norm_factor,'-k','LineWidth',lw)
%     plot(phi_TC, term_ribo_filled_A/norm_factor,'-','LineWidth',lw,'Color',colors(1,:))
    plot(phi_TC, term_free_tRNA/norm_factor,'-','LineWidth',lw,'Color',aaRS_col)
    plot(phi_TC, term_charged_tRNA/norm_factor,'-','LineWidth',lw,'Color',Tu_col)
%     plot(phi_TC, term_TC/norm_factor,'-','LineWidth',lw,'Color',colors(4,:))

    plot(phi_TC, all_other_terms/norm_factor,':k','LineWidth',lw)
    
    plot(phi_TC(sol),term_tRNA_excess(sol)/norm_factor,'ok','MarkerFaceColor','y','MarkerSize',10)

    set(gca,'Xlim',xlims,'YLim',ylims)
    
    if i~=6
       set(gca,'XTickLabels','','YTickLabels','') 
    else
       xlabel('\phi_{TC}') 
       ylabel('tRNA (norm. to ribo)')
    end
    default_plot(0)
        title(sprintf('\\phi_{Tu}=%.3f, \\phi_{aaRS} = %.3f',phi_Tu(i),phi_aaRS(i)),'FontWeight','normal','FontSize',12)

    
end

set(gcf,'Position',fig_pos)
set(gcf,'Renderer','Painters')



