

l_Tu = 394;
l_aaRS = 987;  % size_evaluation_tRNA_synthetase_20210319 
l_ribo = 7300; 
l_30S = 3108; %Wittmann 1982
l_Ts = 283;
l_G = 704;
l_P = 188;
l_IF1 = 72;
l_IF2 = 890;
l_IF3 = 180;
l_RF1 = 362;
l_RF4 = 185;
l_av = 200;

l_TC = 394*1.6; 


% taking molecular weight of tRNA + Tu = 68 kDa, converting back to a.a.... Does not make too much sense...
% tRNA ~ 25 kDa
% EF-Tu ~ 43.284 kDa 

% proteome fraction allocated to translation sector
% phi_trl = 0.335; % from ribosome profiling data: species (E. coli, B. subtilis, V. natriegens) averaged summed of core TFs considered. 



% diffusion um^2/s
D_subunit = 0.2; %+/- 0.1   % Bakshi2012 (D30S = 0.12), Sanamrad2014 (D50S = 0.24, D30S = 0.28, see supp table S1)
D_ribo = 0.05;      % Bakshi2012 (Dribo = 0.04), Sanamrad2014 (Dribo=0.055, see Supp table S4). 
D_TC = 3;           % Volkov 2018
D_tRNA = 8;         % Volkov2018, Plochowietz2017
D_G = D_TC*(l_G/l_TC)^(-1/3);
D_aaRS = D_TC*(l_aaRS/l_TC)^(-1/3);
D_Ts = D_TC*(l_Ts/l_TC)^(-1/3);
D_IF1 = D_TC*(l_IF1/l_TC)^(-1/3);
D_IF2 = D_TC*(l_IF2/l_TC)^(-1/3);
D_IF3 = D_TC*(l_IF3/l_TC)^(-1/3);
D_RF1 = D_TC*(l_RF1/l_TC)^(-1/3);
D_RF4 = D_TC*(l_RF4/l_TC)^(-1/3);
D_Tu = D_TC*(l_Tu/l_TC)^(-1/3);


lambda = log(2)/(21*60);
P = 2.6E6;

n_aa = 20;       % scaling factor for the coarse-graining

k_on_TC =   6.4;          % Value from Dai et al, 2016. uM^-1 s^-1
k_on_G =    k_on_TC*(D_G+D_ribo)/(D_TC+D_ribo);
k_on_aaRS = k_on_TC*(D_tRNA+D_aaRS)/(D_TC+D_ribo);    % assume similar diffusion of aaRS and tRNA to get factor of 2 (factor of 2 since both components diffusings).
k_on_RF1 =  k_on_TC*(D_RF1+D_ribo)/(D_TC+D_ribo);
k_on_RF4 =  k_on_TC*(D_RF4+D_ribo)/(D_TC+D_ribo);
k_on_Ts =   k_on_TC*(D_Ts+D_ribo)/(D_TC+D_ribo);


k_on_IF1 = k_on_TC*(D_IF1+D_subunit)/(D_TC+D_ribo);
k_on_IF2 = k_on_TC*(D_IF2+D_subunit)/(D_TC+D_ribo);
k_on_IF3 = k_on_TC*(D_IF3+D_subunit)/(D_TC+D_ribo);
k_on_50S = k_on_TC*(D_subunit+D_subunit)/(D_TC+D_ribo); % new addition

k_Tu_tRNA = k_on_TC*(D_tRNA+D_Tu)/(D_TC+D_ribo);


%%
prot_frac_data = [...
21.1247	19.53388	22.07433	21.7659	14.15759	9.89499	9.24928	13.19215	6.66107
6.1581	5.40475	6.1353	6.93434	2.33758	3.52517	2.04216	6.45991	3.89793
2.9015	2.48159	2.90714	3.31587	1.52763	1.81189	1.11963	1.55383	1.01148
1.8936	1.98567	1.59367	2.10142	0.81727	0.86099	0.67471	0.81191	0.47938
0.7358	0.56155	0.72365	0.92214	0.36849	0.36977	0.35815	0.43304	0.1982
0.2898	0.22307	0.33057	0.31581	0.29034	0.1951	0.2084	0.14191	0.11191
0.1242	0.12416	0.1094	0.13898	0.06165	0.07549	0.05853	0.07652	0.05397
0.0792	0.07676	0.05875	0.1021	0.0177	0.03128	0.01985	0.04892	0.01859
0.1234	0.13151	0.11588	0.12288	0.05207	0.08198	0.05704	0.09855	0.06576
0.1039	0.13947	0.10915	0.06306	0.05488	0.05453	0.04485	0.04757	0.03176]/100;
% order: 
% Ribosome
% EF-Tu
% aaRS
% EF-G
% EF-Ts
% IF2
% IF3
% IF1
% RF4
% RF1/RF2


data_names = {'average fast growth', ...
    '\itB. subtilis,\rm LB',...
    '\itE. coli,\rm RDM',...
    '\itV. natriegens,\rm LB+3% NaCl',...
    '\itC. crescentus,\rm PYE',...
    '\itE. coli,\rm MOPS minimal',...
    '\itC. crescentus,\rm M2G',...
    '\itE. coli,\rm M9 glucose',...
    '\itE. coli,\rm forced glucose limitation'};


% one for each condition
phi_trl = [33.5 30.66241	34.15784	35.7825	19.6852	16.90119	13.8326	22.86431	12.53005]/100;
doubling_times = [21 21 21.5 19 96 56.3 146 48 122];
lambda = log(2)./(doubling_times*60);

% for the different species/growth conditions? Do I have the codon usage?
corr_three_stops =  1.05; % factor from the three stop codon solution sqrt(1 + 2*sqrt(f_UAG*f_UGA))


tRNA_to_ribo = [6.5 6.5 6.5 6.5 9 8 11 7.5 10.5]; % From Dong 1996 across the different growth rates
% phi_R = 0.211; 

phi_R = [21.1 19.53388 22.07433 21.7659 14.15759 9.89499 9.24928 13.19215 6.66107]/100;
R_tot = phi_R*P/l_ribo;
tRNA = R_tot.*tRNA_to_ribo;



%%
% order: 
% 1 Ribosome
% 2 EF-Tu
% 3 aaRS
% 4 EF-G
% 5 EF-Ts
% 6 IF2
% 7 IF3
% 8 IF1
% 9 RF4
% 10 RF1/RF2

k_el_max = 22;      % from Dai et al, in s^-1

opt_abundance = NaN(size(prot_frac_data));
for i = 1:size(prot_frac_data,2)
    
    % form of solution
    phi_G_theo = sqrt(l_ribo*l_G/k_on_G)*sqrt(lambda(i)/P);
    phi_Ts_theo = sqrt(l_Ts*l_Tu/k_on_Ts)*sqrt(lambda(i)/P);
    phi_Tu_theo = sqrt(l_ribo*l_Tu*n_aa/k_on_TC)*sqrt(lambda(i)/P)+phi_Ts_theo;
    opt_abundance(i,2) = phi_Tu_theo;
    opt_abundance(i,4) = phi_G_theo;
    opt_abundance(i,5) = phi_Ts_theo;
    
    phi_123m = sqrt(l_av/k_on_50S);
    phi_IF1_diff = sqrt(l_ribo*l_IF1/(l_av*k_on_IF1));
    phi_IF1_theo = (sqrt(l_ribo*l_IF1/(l_av*k_on_IF1)*(1+(l_IF2+l_IF3)/l_ribo)) + l_IF1/l_av*phi_123m)*sqrt(lambda(i)/P);
    phi_IF2_theo = (sqrt(3*l_ribo*l_IF2/(4*l_av*k_on_IF2))+l_IF2/l_av*(phi_IF1_diff + phi_123m))*sqrt(lambda(i)/P);
    phi_IF3_theo = (sqrt(3*l_ribo*l_IF3/(4*l_av*k_on_IF3))+l_IF3/l_av*(phi_IF1_diff + phi_123m))*sqrt(lambda(i)/P);
    opt_abundance(i,6) = phi_IF2_theo;
    opt_abundance(i,7) = phi_IF3_theo;
    opt_abundance(i,8) = phi_IF1_theo;

    phi_RF1_theo = sqrt(l_ribo*l_RF1/(l_av*k_on_RF1))*sqrt(lambda(i)/P)*corr_three_stops;
    phi_RF4_theo = sqrt(l_ribo*l_RF4/(l_av*k_on_RF4))*sqrt(lambda(i)/P);
    opt_abundance(i,9) = phi_RF4_theo;
    opt_abundance(i,10) = phi_RF1_theo;
   
    % % % aaRS
    phi_Tu_diff= sqrt(l_ribo*l_Tu*n_aa/k_on_TC)*sqrt(lambda(i)/P);
    k_on_TC_phi = k_on_TC*P/l_Tu/n_aa;
    
    excess_t = tRNA(i)/(P*lambda(i)) - 2/k_el_max -1/(k_on_TC_phi*phi_Tu_diff) - phi_Tu_diff/(l_Tu*lambda(i));
    phi_aaRS_theo = n_aa*l_aaRS/(P*k_on_aaRS*excess_t);
    opt_abundance(i,3) = phi_aaRS_theo;
    
    phi_ribo_theo = phi_trl(i) - sum(opt_abundance(i,2:end));
    opt_abundance(i,1) = phi_ribo_theo;
end


%%
format_print = '%.3f\t %.3f\t%.3f\t %.3f\t%.3f\t %.3f\t%.3f\t %.3f\t%.3f\t %.3f\n';
for i=1:length(data_names)
    
    fprintf(sprintf(format_print,opt_abundance(i,:)*100))
end

%% Fig. 4 average

markersize= 13;


% % species averaged core TF synthesis fraction from ribosome profiling
% phi_ribo_exp =  0.211247;
% phi_Tu_exp =    0.0616;
% phi_aaRS_exp =  0.0290;
% phi_G_exp =     0.01894;
% phi_Ts_exp =    0.00736;
% phi_IF2_exp =   0.002898;
% phi_IF1_exp =   0.000792;
% phi_IF3_exp =   0.001234;
% phi_RF1_exp =   0.001039;
% phi_RF4_exp =   0.001234;
% 
color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;
colors=[0 0 0; color_Tu; color_aaRS; color_G; color_Ts; color_IF2; color_IF3; color_IF1; color_RF4; color_RF1];

x_lims = [0.6E-4 2E-1];
x_plots = logspace(-4.5,0,10);


fontsize = 14;

plot_id=[1];

% data_names = {'\itB. subtilis,\rm LB',...
%     '\itE. coli,\rm MOPS complete',...
%     '\itV. natriegens,\rm LB+3% NaCl',...
%     '\itC. crescentus,\rm PYE',...
%     '\itE. coli,\rm MOPS minimal',...
%     '\itC. crescentus,\rm M2G',...
%     '\itE. coli,\rm M9 glucose',...
%     '\itE. coli,\rm forced glucose limitation'};

subplot = @(m,n,p) subtightplot (m, n, p, [0 0.05], [0.2 0.08], [0.2 0.02]);

% fig_pos = [274        1809        1440         421];
fig_pos = [ 274        1728         391         502];


figure
for i = 1:length(plot_id)
    
    subplot(1,length(plot_id),i)
    hold on
    ind = plot_id(i);
    
    for j =2:size(prot_frac_data,1)
        plot(opt_abundance(ind,j),prot_frac_data(j,ind),'ok','MarkerSize',markersize,'MarkerFaceColor',colors(j,:));
    end
    plot(x_plots,x_plots,':k')
%     plot(x_plots,1/sqrt(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'-k')
%     plot(x_plots,1/(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'--k')


    xlabel(sprintf('Optimal proteome fraction (diffusion limited),\n %s',data_names{ind}))
    ylabel(sprintf('Observed proteome fraction,\n %s',data_names{ind}))
    default_plot(1)
    set(gca,'XLim',x_lims,'YLim',x_lims);
    set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1],'FontSize',fontsize)
   
end
set(gcf,'Position',fig_pos)




%% individual fast growth

markersize= 13;


% % species averaged core TF synthesis fraction from ribosome profiling
% phi_ribo_exp =  0.211247;
% phi_Tu_exp =    0.0616;
% phi_aaRS_exp =  0.0290;
% phi_G_exp =     0.01894;
% phi_Ts_exp =    0.00736;
% phi_IF2_exp =   0.002898;
% phi_IF1_exp =   0.000792;
% phi_IF3_exp =   0.001234;
% phi_RF1_exp =   0.001039;
% phi_RF4_exp =   0.001234;
% 
color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;
colors=[0 0 0; color_Tu; color_aaRS; color_G; color_Ts; color_IF2; color_IF3; color_IF1; color_RF1; color_RF4];

x_lims = [0.6E-4 2E-1];
x_plots = logspace(-4.5,0,10);


fontsize = 14;

plot_id=[2 3 4];

% data_names = {'\itB. subtilis,\rm LB',...
%     '\itE. coli,\rm MOPS complete',...
%     '\itV. natriegens,\rm LB+3% NaCl',...
%     '\itC. crescentus,\rm PYE',...
%     '\itE. coli,\rm MOPS minimal',...
%     '\itC. crescentus,\rm M2G',...
%     '\itE. coli,\rm M9 glucose',...
%     '\itE. coli,\rm forced glucose limitation'};

subplot = @(m,n,p) subtightplot (m, n, p, [0 0.09], [0.2 0.08], [0.1 0.02]);

fig_pos = [ 274        1728        1517         502];


figure
for i = 1:length(plot_id)
    
    subplot(1,length(plot_id),i)
    hold on
    ind = plot_id(i);
    
    for j =2:size(prot_frac_data,1)
        plot(opt_abundance(ind,j),prot_frac_data(j,ind),'ok','MarkerSize',markersize,'MarkerFaceColor',colors(j,:));
    end
    plot(x_plots,x_plots,':k')
%     plot(x_plots,1/sqrt(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'-k')
%     plot(x_plots,1/(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'--k')


    xlabel(sprintf('Optimal proteome fraction (diffusion limited),\n %s',data_names{ind}))
    ylabel(sprintf('Observed proteome fraction,\n %s',data_names{ind}))
    default_plot(1)
    set(gca,'XLim',x_lims,'YLim',x_lims);
    set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1],'FontSize',fontsize)
   
end
set(gcf,'Position',fig_pos)


%% individual slow growth

markersize= 13;


% % species averaged core TF synthesis fraction from ribosome profiling
% phi_ribo_exp =  0.211247;
% phi_Tu_exp =    0.0616;
% phi_aaRS_exp =  0.0290;
% phi_G_exp =     0.01894;
% phi_Ts_exp =    0.00736;
% phi_IF2_exp =   0.002898;
% phi_IF1_exp =   0.000792;
% phi_IF3_exp =   0.001234;
% phi_RF1_exp =   0.001039;
% phi_RF4_exp =   0.001234;
% 
color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;
colors=[0 0 0; color_Tu; color_aaRS; color_G; color_Ts; color_IF2; color_IF3; color_IF1; color_RF1; color_RF4];

x_lims = [0.6E-4 2E-1];
x_plots = logspace(-4.5,0,10);


fontsize = 14;

plot_id=[ 8 6 9 5 7];

% data_names = {'\itB. subtilis,\rm LB',...
%     '\itE. coli,\rm MOPS complete',...
%     '\itV. natriegens,\rm LB+3% NaCl',...
%     '\itC. crescentus,\rm PYE',...
%     '\itE. coli,\rm MOPS minimal',...
%     '\itC. crescentus,\rm M2G',...
%     '\itE. coli,\rm M9 glucose',...
%     '\itE. coli,\rm forced glucose limitation'};

subplot = @(m,n,p) subtightplot (m, n, p, [0 0.05], [0.2 0.08], [0.06 0.02]);

fig_pos = [  36        1728        2410         502];


figure
for i = 1:length(plot_id)
    
    subplot(1,length(plot_id),i)
    hold on
    ind = plot_id(i);
    
    for j =2:size(prot_frac_data,1)
        plot(opt_abundance(ind,j),prot_frac_data(j,ind),'ok','MarkerSize',markersize,'MarkerFaceColor',colors(j,:));
    end
    plot(x_plots,x_plots,':k')
%     plot(x_plots,1/sqrt(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'-k')
%     plot(x_plots,1/(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'--k')


    xlabel(sprintf('Optimal proteome fraction (diffusion limited),\n %s',data_names{ind}))
    ylabel(sprintf('Observed proteome fraction,\n %s',data_names{ind}))
    default_plot(1)
    set(gca,'XLim',x_lims,'YLim',x_lims);
    set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1],'FontSize',fontsize)
   
end
set(gcf,'Position',fig_pos)






%% combined

markersize= 13;


% % species averaged core TF synthesis fraction from ribosome profiling
% phi_ribo_exp =  0.211247;
% phi_Tu_exp =    0.0616;
% phi_aaRS_exp =  0.0290;
% phi_G_exp =     0.01894;
% phi_Ts_exp =    0.00736;
% phi_IF2_exp =   0.002898;
% phi_IF1_exp =   0.000792;
% phi_IF3_exp =   0.001234;
% phi_RF1_exp =   0.001039;
% phi_RF4_exp =   0.001234;
% 
color_Tu =  [255 0 0]/255;
color_aaRS = [255 144 201]/255;
color_G = [255 52 255]/255;
color_Ts = [163 1 89]/255;
color_IF1 = [10 166 216]/255;
color_IF2 = [59 93 255]/255;
color_IF3 = [2 0 166]/255;
color_RF1 = [59 151 0]/255;
color_RF4 = [4 247 87]/255;
colors=[0 0 0; color_Tu; color_aaRS; color_G; color_Ts; color_IF2; color_IF3; color_IF1; color_RF4; color_RF1 ];

x_lims = [0.6E-4 2E-1];
x_plots = logspace(-4.5,0,10);


fontsize = 12;

plot_id=[2 3 4 8 6 9 5 7];

% data_names = {'\itB. subtilis,\rm LB',...
%     '\itE. coli,\rm MOPS complete',...
%     '\itV. natriegens,\rm LB+3% NaCl',...
%     '\itC. crescentus,\rm PYE',...
%     '\itE. coli,\rm MOPS minimal',...
%     '\itC. crescentus,\rm M2G',...
%     '\itE. coli,\rm M9 glucose',...
%     '\itE. coli,\rm forced glucose limitation'};

subplot = @(m,n,p) subtightplot (m, n, p, [0.12 0.1], [0.1 0.08], [0.1 0.05]);

fig_pos = [  381          54         918        1051];


figure
for i = 1:length(plot_id)
    
    subplot(3,3,i)
    hold on
    ind = plot_id(i);
    
    for j =2:size(prot_frac_data,1)
        plot(opt_abundance(ind,j),prot_frac_data(j,ind),'ok','MarkerSize',markersize,'MarkerFaceColor',colors(j,:));
    end
    plot(x_plots,x_plots,':k')
%     plot(x_plots,1/sqrt(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'-k')
%     plot(x_plots,1/(doubling_times(y_ids(i))/doubling_times(ref_id))*x_plots,'--k')


    xlabel(sprintf('Optimal proteome fraction (diffusion limited),\n %s',data_names{ind}))
    ylabel(sprintf('Observed proteome fraction,\n %s',data_names{ind}))
    default_plot(1)
    set(gca,'XLim',x_lims,'YLim',x_lims);
    set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1],'FontSize',fontsize)
   
end
set(gcf,'Position',fig_pos)





%%


markersize= 13;

x_plot = [1E-4 4E-1];
figure
hold on 
plot(x_plot,x_plot,':k')

plot([0.1 0.1],0.01*[1 sqrt(n_aa*l_Tu/l_G)],'-k')
plot([0.2 0.2],0.01*[1 sqrt(l_av)],'-k')


factor = 1.2;
fontsize = 16;

plot(phi_Tu_theo,phi_Tu_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_Tu);
text(phi_Tu_theo*factor,phi_Tu_exp,'EF-Tu','Color',color_Tu,'FontWeight','bold','FontSize',fontsize);

plot(phi_aaRS_theo,phi_aaRS_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_aaRS);
text(phi_aaRS_theo*factor,phi_aaRS_exp,'aaRS','Color',color_aaRS,'FontWeight','bold','FontSize',fontsize);

plot(phi_G_theo,phi_G_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_G);
text(phi_G_theo*factor,phi_G_exp,'EF-G','Color',color_G,'FontWeight','bold','FontSize',fontsize);

plot(phi_Ts_theo,phi_Ts_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_Ts);
text(phi_Ts_theo*factor,phi_Ts_exp,'EF-Ts','Color',color_Ts,'FontWeight','bold','FontSize',fontsize);

plot(phi_RF1_theo,phi_RF1_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_RF1);
text(phi_RF1_theo*factor,phi_RF1_exp,'RF1/RF2','Color',color_RF1,'FontWeight','bold','FontSize',fontsize);

plot(phi_RF4_theo,phi_RF4_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_RF4);
text(phi_RF4_theo*factor,phi_RF4_exp,'RF4','Color',color_RF4,'FontWeight','bold','FontSize',fontsize);


plot(phi_IF1_theo,phi_IF1_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF1);
text(phi_IF1_theo*factor,phi_IF1_exp,'IF1','Color',color_IF1,'FontWeight','bold','FontSize',fontsize);

plot(phi_IF2_theo,phi_IF2_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF2);
text(phi_IF2_theo*factor,phi_IF2_exp,'IF2','Color',color_IF2,'FontWeight','bold','FontSize',fontsize);

plot(phi_IF3_theo,phi_IF3_exp,'ok','MarkerSize',markersize,'MarkerFaceColor',color_IF3);
text(phi_IF3_theo*factor,phi_IF3_exp,'IF3','Color',color_IF3,'FontWeight','bold','FontSize',fontsize);

plot(phi_ribo_theo,phi_ribo_exp,'ok','MarkerSize',markersize,'MarkerFaceColor','k');
text(phi_ribo_theo*factor,phi_ribo_exp,'ribosome','Color','k','FontWeight','bold','FontSize',fontsize);


xlabel('Optimal proteome fraction \phi^* (theory, diffusion only)')
ylabel('Observed proteome fraction \phi')
default_plot(1)
set(gca,'XLim',x_plot,'YLim',x_plot);
set(gca,'XTick',[1E-4 1E-3 1E-2 1E-1])
set(gcf,'Position',[549        1600         491         479]);
set(gca,'FontSize',20)












