%% ribo read density

data_dir = %path of ribosome profiling data
files = [];
files{1} = 'GSE53767_fp_rdm*.wig'; % 



species = 'ecoli';
conditions_ribo = {'MG1655, GWL2014, MOPS comp.'};

ribo_bool = 1;
winsor_cut = 0.02;
gap = 20;
n_boot = 50;
rRNA_rem_bool = 0;


% use the one in the directyory expression_translation_factors
[genes, gene_length,read_density_ribo, median_reads_per_gene,reads_per_gene_ribo, ...
    rescaled_reads_per_gene_ribo, winsorized_read_density_ribo,...
    winsorized_reads_per_gene_ribo, winsorized_rescaled_reads_per_gene_ribo,...
    winsorized_median_reads_ribo, non_rRNA_raw_reads_ribo, all_raw_reads_ribo,...
    bootstrap_winsorized_read_density_ribo,bootstrap_rescaled_reads_per_gene_ribo] = ...
    compute_read_density_20200218(data_dir,files,gap,winsor_cut,ribo_bool,n_boot,species);

% summing the density on tufA and tufB
winsorized_read_density_ribo(:,3735) = winsorized_read_density_ribo(:,3735)+winsorized_read_density_ribo(:,1875);
winsorized_read_density_ribo(:,1875) = NaN;

%% gene length weighted by expression

av_gene_length = [];

for i = 1:length(files)   
    bool = ~isnan(winsorized_read_density_ribo(i,:));
    av_gene_length(i) = sum(gene_length(bool).*winsorized_read_density_ribo(i,bool)')/sum(winsorized_read_density_ribo(i,bool))/3;
end



